/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullerScheduler;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.OnDemandJobScheduler;

public class UpdatePullerSchedulerTest {
    private UpdatePuller updatePuller;

    @Before
    public void setUp() {
        this.updatePuller = (UpdatePuller)Mockito.mock(UpdatePuller.class);
    }

    @Test
    public void skipUpdatePullingSchedulingWithZeroInterval() throws Throwable {
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        UpdatePullerScheduler pullerScheduler = new UpdatePullerScheduler(jobScheduler, (LogProvider)NullLogProvider.getInstance(), this.updatePuller, 0L);
        pullerScheduler.init();
        Mockito.verifyZeroInteractions((Object[])new Object[]{jobScheduler, this.updatePuller});
        pullerScheduler.shutdown();
    }

    @Test
    public void scheduleUpdatePulling() throws Throwable {
        OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();
        UpdatePullerScheduler pullerScheduler = new UpdatePullerScheduler((JobScheduler)jobScheduler, (LogProvider)NullLogProvider.getInstance(), this.updatePuller, 10L);
        pullerScheduler.init();
        jobScheduler.runJob();
        ((UpdatePuller)Mockito.verify((Object)this.updatePuller)).pullUpdates();
        Assert.assertNotNull((String)"Job should be scheduled", (Object)jobScheduler.getJob());
        pullerScheduler.shutdown();
        Assert.assertNull((String)"Job should be canceled", (Object)jobScheduler.getJob());
    }
}

