/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.LockStatus;
import org.neo4j.kernel.ha.lock.SlaveLockManager;
import org.neo4j.kernel.ha.lock.SlaveLocksClient;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

@RunWith(value=MockitoJUnitRunner.class)
public class SlaveLocksClientTest {
    @Mock
    private Master master;
    @Mock
    private Locks.Client local;
    @Mock
    private Locks lockManager;
    @Mock
    private RequestContextFactory requestContextFactory;
    @Mock
    private AvailabilityGuard availabilityGuard;
    @Mock
    private SlaveLockManager.Configuration config;
    @InjectMocks
    private SlaveLocksClient client;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.local.tryExclusiveLock((Locks.ResourceType)Matchers.any(Locks.ResourceType.class), ((Long)Matchers.any(Long.TYPE)).longValue())).thenReturn((Object)true);
        Mockito.when((Object)this.local.trySharedLock((Locks.ResourceType)Matchers.any(Locks.ResourceType.class), ((Long)Matchers.any(Long.TYPE)).longValue())).thenReturn((Object)true);
        Mockito.when((Object)this.lockManager.newClient()).thenReturn((Object)this.local);
        Mockito.when((Object)this.master.acquireSharedLock((RequestContext)Matchers.any(RequestContext.class), (Locks.ResourceType)Matchers.any(Locks.ResourceType.class), (long[])Matchers.anyVararg())).thenReturn((Object)new TransactionStreamResponse((Object)new LockResult(LockStatus.OK_LOCKED), null, TransactionStream.EMPTY, ResourceReleaser.NO_OP));
        Mockito.when((Object)this.master.acquireExclusiveLock((RequestContext)Matchers.any(RequestContext.class), (Locks.ResourceType)Matchers.any(Locks.ResourceType.class), (long[])Matchers.anyVararg())).thenReturn((Object)new TransactionStreamResponse((Object)new LockResult(LockStatus.OK_LOCKED), null, TransactionStream.EMPTY, ResourceReleaser.NO_OP));
        Mockito.when((Object)this.availabilityGuard.isAvailable(Matchers.anyLong())).thenReturn((Object)true);
    }

    @Test
    public void shouldNotTakeSharedLockOnMasterIfWeAreAlreadyHoldingSaidLock() {
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Master)Mockito.verify((Object)this.master)).acquireSharedLock(null, (Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void shouldNotTakeExclusiveLockOnMasterIfWeAreAlreadyHoldingSaidLock() {
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Master)Mockito.verify((Object)this.master)).acquireExclusiveLock(null, (Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void shouldAllowAcquiringReleasingAndReacquiringExclusive() throws Exception {
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldAllowAcquiringReleasingAndReacquiringShared() throws Exception {
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).trySharedLock((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).releaseShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldNotTalkToLocalLocksOnReentrancyExclusive() throws Exception {
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)1))).tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)0))).releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldNotTalkToLocalLocksOnReentrancyShared() throws Exception {
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)1))).trySharedLock((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)0))).releaseShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldReturnNoLockSessionIfNotInitialized() throws Exception {
        int lockSessionId = this.client.getLockSessionId();
        MatcherAssert.assertThat((Object)lockSessionId, (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void shouldReturnDelegateIdIfInitialized() throws Exception {
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        int lockSessionId = this.client.getLockSessionId();
        MatcherAssert.assertThat((Object)lockSessionId, (Matcher)CoreMatchers.equalTo((Object)0));
    }
}

