/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.util.Collections;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.InstanceId;
import org.neo4j.kernel.ha.com.master.SlavePriorities;
import org.neo4j.kernel.ha.com.master.SlavePriority;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.ha.transaction.CommitPusher;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;

public class TransactionPropagatorTest {
    @Rule
    public final LifeRule life = new LifeRule(true);

    @Test
    public void shouldCapUndesiredSlaveCountPushLogging() throws Exception {
        int serverId = 1;
        final InstanceId instanceId = new InstanceId(serverId);
        TransactionPropagator.Configuration config = new TransactionPropagator.Configuration(){

            public int getTxPushFactor() {
                return 1;
            }

            public InstanceId getServerId() {
                return instanceId;
            }

            public SlavePriority getReplicationStrategy() {
                return SlavePriorities.fixed();
            }
        };
        Log logger = (Log)Mockito.mock(Log.class);
        Slaves slaves = (Slaves)Mockito.mock(Slaves.class);
        Mockito.when((Object)slaves.getSlaves()).thenReturn(Collections.emptyList());
        CommitPusher pusher = (CommitPusher)Mockito.mock(CommitPusher.class);
        TransactionPropagator propagator = (TransactionPropagator)this.life.add((Lifecycle)new TransactionPropagator(config, logger, slaves, pusher));
        for (int i = 0; i < 10; ++i) {
            propagator.committed(1L, serverId);
        }
        ((Log)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).warn(Matchers.anyString());
    }
}

