/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransientDatabaseFailureException;
import org.neo4j.kernel.impl.util.LazySingleReference;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class DelegateInvocationHandler<T>
implements InvocationHandler {
    private volatile T delegate;
    private final LazySingleReference<T> concrete;
    private final Log log;
    private final String componentName;

    public DelegateInvocationHandler(final Class<T> interfaceClass, LogProvider logProvider) {
        this.concrete = new LazySingleReference<T>(){

            protected T create() {
                return Proxy.newProxyInstance(DelegateInvocationHandler.class.getClassLoader(), new Class[]{interfaceClass}, new Concrete());
            }
        };
        this.log = logProvider.getLog(this.getClass());
        this.componentName = interfaceClass.getSimpleName();
    }

    public void setDelegate(T delegate) {
        this.log("Delegate updated from %s to %s", this.delegate, delegate);
        this.delegate = Objects.requireNonNull(delegate, "delegate should not be null");
        this.harden();
        this.concrete.invalidate();
    }

    void harden() {
        this.log("Delegate hardened to %s", this.delegate);
        ((Concrete)Proxy.getInvocationHandler(this.concrete.get())).set(this.delegate);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.delegate == null) {
            throw new TransactionFailureException("Instance state changed after this transaction started.");
        }
        return DelegateInvocationHandler.proxyInvoke(this.delegate, method, args);
    }

    private static Object proxyInvoke(Object delegate, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public T cement() {
        this.log("Delegate cemented", new Object[0]);
        return (T)this.concrete.get();
    }

    public String toString() {
        return "Delegate[" + this.delegate + "]";
    }

    private void log(String format, Object ... arguments) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("[" + this.componentName + "]" + format, arguments);
        }
    }

    private static class Concrete<T>
    implements InvocationHandler {
        private volatile T delegate;

        private Concrete() {
        }

        void set(T delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.delegate == null) {
                throw new TransientDatabaseFailureException("Transaction state is not valid. Perhaps a state change ofthe database has happened while this transaction was running?");
            }
            return DelegateInvocationHandler.proxyInvoke(this.delegate, method, args);
        }

        public String toString() {
            return "Concrete[" + this.delegate + "]";
        }
    }
}

