/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlaveClient;
import org.neo4j.kernel.ha.com.master.SlaveFactory;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class DefaultSlaveFactory
implements SlaveFactory {
    private final LogProvider logProvider;
    private final Monitors monitors;
    private final int chunkSize;
    private StoreId storeId;

    public DefaultSlaveFactory(LogProvider logProvider, Monitors monitors, int chunkSize) {
        this.logProvider = logProvider;
        this.monitors = monitors;
        this.chunkSize = chunkSize;
    }

    @Override
    public Slave newSlave(LifeSupport life, ClusterMember clusterMember) {
        return (Slave)life.add((Lifecycle)new SlaveClient(clusterMember.getInstanceId(), clusterMember.getHAUri().getHost(), clusterMember.getHAUri().getPort(), this.logProvider, this.storeId, 2, this.chunkSize, (ByteCounterMonitor)this.monitors.newMonitor(ByteCounterMonitor.class, SlaveClient.class, new String[0]), (RequestMonitor)this.monitors.newMonitor(RequestMonitor.class, SlaveClient.class, new String[0])));
    }

    @Override
    public void setStoreId(StoreId storeId) {
        this.storeId = storeId;
    }
}

