/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.com.ComException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleListener;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterRule;

public class ClusterTransactionTest {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass());
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void givenClusterWhenShutdownMasterThenCannotStartTransactionOnSlave() throws Throwable {
        long nodeId;
        ClusterManager.ManagedCluster cluster = this.clusterRule.withProvider(ClusterManager.fromXml((URI)this.getClass().getResource("/threeinstances.xml").toURI())).withSharedSetting((Setting<?>)HaSettings.ha_server, ":6001-6005").withSharedSetting((Setting<?>)HaSettings.tx_push_factor, "2").startCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        final HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = master.beginTx();){
            nodeId = master.createNode().getId();
            tx.success();
        }
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        final FutureTask<Boolean> result = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try (Transaction tx = slave.beginTx();){
                    tx.acquireWriteLock((PropertyContainer)slave.getNodeById(nodeId));
                }
                catch (ComException e) {
                    return e.getCause() instanceof TransactionFailureException;
                }
                return false;
            }
        });
        ((LifeSupport)master.getDependencyResolver().resolveDependency(LifeSupport.class)).addLifecycleListener(new LifecycleListener(){

            public void notifyStatusChanged(Object instance, LifecycleStatus from, LifecycleStatus to) {
                if (instance.getClass().getName().contains("DatabaseAvailability") && to == LifecycleStatus.STOPPED) {
                    result.run();
                }
            }
        });
        master.shutdown();
        Assert.assertThat((Object)result.get(), (Matcher)CoreMatchers.equalTo((Object)true));
    }
}

