/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.io.File;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.UniquenessConstraintDefinition;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;
import org.neo4j.tooling.GlobalGraphOperations;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={NodePropertyExistenceConstraintHaIT.class, RelationshipPropertyExistenceConstraintHaIT.class, UniquenessConstraintHaIT.class})
public class ConstraintHaIT {

    public static abstract class AbstractConstraintHaIT {
        private static final String TYPE = "Type";
        private static final String PROPERTY_KEY = "name";
        @Rule
        public ClusterRule clusterRule = new ClusterRule(this.getClass());

        protected abstract void createConstraint(GraphDatabaseService var1, String var2, String var3);

        protected abstract void createEntityInTx(GraphDatabaseService var1, String var2, String var3, String var4);

        protected abstract void createConstraintViolation(GraphDatabaseService var1, String var2, String var3, String var4);

        protected abstract void assertConstraintHolds(GraphDatabaseService var1, String var2, String var3, String var4);

        protected abstract Class<? extends ConstraintDefinition> constraintDefinitionClass();

        @Test
        public void shouldCreateConstraintOnMaster() throws Exception {
            ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            try (Transaction tx = master.beginTx();){
                this.createConstraint((GraphDatabaseService)master, TYPE, PROPERTY_KEY);
                tx.success();
            }
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            for (HighlyAvailableGraphDatabase clusterMember : cluster.getAllMembers()) {
                Transaction tx = clusterMember.beginTx();
                Throwable throwable = null;
                try {
                    ConstraintDefinition constraint = (ConstraintDefinition)Iterables.single((Iterable)clusterMember.schema().getConstraints());
                    AbstractConstraintHaIT.validateLabelOrRelationshipType(constraint);
                    Assert.assertEquals((Object)PROPERTY_KEY, (Object)Iterables.single((Iterable)constraint.getPropertyKeys()));
                    tx.success();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
        }

        @Test
        public void shouldNotBePossibleToCreateConstraintsDirectlyOnSlaves() throws Exception {
            ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            try (Transaction ignored = slave.beginTx();){
                this.createConstraint((GraphDatabaseService)slave, TYPE, PROPERTY_KEY);
                Assert.fail((String)"We expected to not be able to create a constraint on a slave in a cluster.");
            }
            catch (QueryExecutionException e) {
                Assert.assertThat((Object)Exceptions.rootCause((Throwable)e), (Matcher)Matchers.instanceOf(InvalidTransactionTypeKernelException.class));
            }
        }

        @Test
        public void shouldRemoveConstraints() throws Exception {
            ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            try (Transaction tx = master.beginTx();){
                this.createConstraint((GraphDatabaseService)master, TYPE, PROPERTY_KEY);
                tx.success();
            }
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            this.createEntityInTx((GraphDatabaseService)cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]), TYPE, PROPERTY_KEY, "Foo");
            tx = master.beginTx();
            var4_4 = null;
            try {
                ((ConstraintDefinition)Iterables.single((Iterable)master.schema().getConstraints())).drop();
                tx.success();
            }
            catch (Throwable x2) {
                var4_4 = x2;
                throw x2;
            }
            finally {
                if (tx != null) {
                    if (var4_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            var4_4.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            for (HighlyAvailableGraphDatabase clusterMember : cluster.getAllMembers()) {
                Transaction tx = clusterMember.beginTx();
                Throwable throwable = null;
                try {
                    Assert.assertEquals((long)Iterables.count((Iterable)clusterMember.schema().getConstraints()), (long)0L);
                    Assert.assertEquals((long)Iterables.count((Iterable)clusterMember.schema().getIndexes()), (long)0L);
                    this.createConstraintViolation((GraphDatabaseService)clusterMember, TYPE, PROPERTY_KEY, "Foo");
                    tx.success();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
        }

        @Test
        public void shouldNotAllowOldUncommittedTransactionsToResumeAndViolateConstraint() throws Exception {
            ClusterManager.ManagedCluster cluster = this.clusterRule.withSharedSetting((Setting<?>)HaSettings.read_timeout, "4000s").startCluster();
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            ThreadToStatementContextBridge txBridge = AbstractConstraintHaIT.threadToStatementContextBridge(slave);
            this.createEntityInTx((GraphDatabaseService)master, TYPE, PROPERTY_KEY, "Foo");
            slave.beginTx();
            this.createConstraintViolation((GraphDatabaseService)slave, TYPE, PROPERTY_KEY, "Foo");
            TopLevelTransaction slaveTx = txBridge.getTopLevelTransactionBoundToThisThread(true);
            txBridge.unbindTransactionFromCurrentThread();
            try (Transaction tx = master.beginTx();){
                this.createConstraint((GraphDatabaseService)master, TYPE, PROPERTY_KEY);
                tx.success();
            }
            txBridge.bindTransactionToCurrentThread(slaveTx);
            try {
                slaveTx.success();
                slaveTx.close();
                Assert.fail((String)"Expected this commit to fail :(");
            }
            catch (org.neo4j.graphdb.TransactionFailureException e) {
                Assert.assertThat((Object)e.getCause().getCause(), (Matcher)Matchers.instanceOf(TransactionFailureException.class));
            }
            this.assertConstraintHolds((GraphDatabaseService)master, TYPE, PROPERTY_KEY, "Foo");
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            this.assertConstraintHolds((GraphDatabaseService)slave, TYPE, PROPERTY_KEY, "Foo");
            this.createEntityInTx((GraphDatabaseService)slave, TYPE, PROPERTY_KEY, "Bar");
            this.createEntityInTx((GraphDatabaseService)master, TYPE, PROPERTY_KEY, "Baz");
        }

        @Test
        public void newSlaveJoiningClusterShouldNotAcceptOperationsUntilConstraintIsOnline() throws Throwable {
            ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            File slaveStoreDirectory = cluster.getStoreDir(slave);
            ClusterManager.RepairKit shutdownSlave = cluster.shutdown(slave);
            FileUtils.deleteRecursively((File)slaveStoreDirectory);
            try (Transaction tx = master.beginTx();){
                this.createConstraint((GraphDatabaseService)master, TYPE, PROPERTY_KEY);
                tx.success();
            }
            slave = shutdownSlave.repair();
            var7_7 = null;
            try (Transaction ignored = slave.beginTx();){
                ConstraintDefinition definition = (ConstraintDefinition)Iterables.single((Iterable)slave.schema().getConstraints());
                Assert.assertThat((Object)definition, (Matcher)Matchers.instanceOf(this.constraintDefinitionClass()));
                Assert.assertThat((Object)Iterables.single((Iterable)definition.getPropertyKeys()), (Matcher)Matchers.equalTo((Object)PROPERTY_KEY));
                AbstractConstraintHaIT.validateLabelOrRelationshipType(definition);
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
        }

        private static ThreadToStatementContextBridge threadToStatementContextBridge(HighlyAvailableGraphDatabase db) {
            DependencyResolver dependencyResolver = db.getDependencyResolver();
            return (ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class);
        }

        private static void validateLabelOrRelationshipType(ConstraintDefinition constraint) {
            if (constraint.isConstraintType(ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE)) {
                Assert.assertEquals((Object)TYPE, (Object)constraint.getRelationshipType().name());
            } else {
                Assert.assertEquals((Object)TYPE, (Object)constraint.getLabel().name());
            }
        }
    }

    public static class UniquenessConstraintHaIT
    extends AbstractConstraintHaIT {
        @Override
        protected void createConstraint(GraphDatabaseService db, String type, String value) {
            db.execute(String.format("CREATE CONSTRAINT ON (n:`%s`) ASSERT n.`%s` IS UNIQUE", type, value));
        }

        @Override
        protected void createEntityInTx(GraphDatabaseService db, String type, String propertyKey, String value) {
            try (Transaction tx = db.beginTx();){
                db.createNode(new Label[]{DynamicLabel.label((String)type)}).setProperty(propertyKey, (Object)value);
                tx.success();
            }
        }

        @Override
        protected void createConstraintViolation(GraphDatabaseService db, String type, String propertyKey, String value) {
            db.createNode(new Label[]{DynamicLabel.label((String)type)}).setProperty(propertyKey, (Object)value);
        }

        @Override
        protected void assertConstraintHolds(GraphDatabaseService db, String type, String propertyKey, String value) {
            try (Transaction tx = db.beginTx();){
                Assert.assertEquals((long)1L, (long)Iterables.toList((Iterator)db.findNodes(DynamicLabel.label((String)type), propertyKey, (Object)value)).size());
                tx.success();
            }
        }

        @Override
        protected Class<? extends ConstraintDefinition> constraintDefinitionClass() {
            return UniquenessConstraintDefinition.class;
        }
    }

    public static class RelationshipPropertyExistenceConstraintHaIT
    extends AbstractConstraintHaIT {
        @Override
        protected void createConstraint(GraphDatabaseService db, String type, String value) {
            db.execute(String.format("CREATE CONSTRAINT ON ()-[r:`%s`]-() ASSERT exists(r.`%s`)", type, value));
        }

        @Override
        protected void createEntityInTx(GraphDatabaseService db, String type, String propertyKey, String value) {
            try (Transaction tx = db.beginTx();){
                Node start = db.createNode();
                Node end = db.createNode();
                Relationship relationship = start.createRelationshipTo(end, (RelationshipType)DynamicRelationshipType.withName((String)type));
                relationship.setProperty(propertyKey, (Object)value);
                tx.success();
            }
        }

        @Override
        protected void createConstraintViolation(GraphDatabaseService db, String type, String propertyKey, String value) {
            Node start = db.createNode();
            Node end = db.createNode();
            start.createRelationshipTo(end, (RelationshipType)DynamicRelationshipType.withName((String)type));
        }

        @Override
        protected void assertConstraintHolds(GraphDatabaseService db, String type, String propertyKey, String value) {
            try (Transaction tx = db.beginTx();){
                for (Relationship relationship : GlobalGraphOperations.at((GraphDatabaseService)db).getAllRelationships()) {
                    if (!relationship.isType((RelationshipType)DynamicRelationshipType.withName((String)type))) continue;
                    Assert.assertTrue((boolean)relationship.hasProperty(propertyKey));
                }
                tx.success();
            }
        }

        @Override
        protected Class<? extends ConstraintDefinition> constraintDefinitionClass() {
            return RelationshipPropertyExistenceConstraintDefinition.class;
        }
    }

    public static class NodePropertyExistenceConstraintHaIT
    extends AbstractConstraintHaIT {
        @Override
        protected void createConstraint(GraphDatabaseService db, String type, String value) {
            db.execute(String.format("CREATE CONSTRAINT ON (n:`%s`) ASSERT exists(n.`%s`)", type, value));
        }

        @Override
        protected void createEntityInTx(GraphDatabaseService db, String type, String propertyKey, String value) {
            try (Transaction tx = db.beginTx();){
                db.createNode(new Label[]{DynamicLabel.label((String)type)}).setProperty(propertyKey, (Object)value);
                tx.success();
            }
        }

        @Override
        protected void createConstraintViolation(GraphDatabaseService db, String type, String propertyKey, String value) {
            db.createNode(new Label[]{DynamicLabel.label((String)type)});
        }

        @Override
        protected void assertConstraintHolds(GraphDatabaseService db, String type, String propertyKey, String value) {
            try (Transaction tx = db.beginTx();){
                ResourceIterator nodes = db.findNodes(DynamicLabel.label((String)type));
                while (nodes.hasNext()) {
                    Node node = (Node)nodes.next();
                    Assert.assertTrue((boolean)node.hasProperty(propertyKey));
                }
                tx.success();
            }
        }

        @Override
        protected Class<? extends ConstraintDefinition> constraintDefinitionClass() {
            return NodePropertyExistenceConstraintDefinition.class;
        }
    }
}

