/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import org.neo4j.cluster.InstanceId;
import org.neo4j.function.Function;
import org.neo4j.function.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ObservedClusterMembers;

public class ClusterMembers {
    private final ObservedClusterMembers observedClusterMembers;
    private final HighAvailabilityMemberStateMachine stateMachine;

    public static Predicate<ClusterMember> inRole(final String role) {
        return new Predicate<ClusterMember>(){

            public boolean test(ClusterMember item) {
                return item.hasRole(role);
            }
        };
    }

    public static Predicate<ClusterMember> hasInstanceId(final InstanceId instanceId) {
        return new Predicate<ClusterMember>(){

            public boolean test(ClusterMember item) {
                return item.getInstanceId().equals((Object)instanceId);
            }
        };
    }

    public ClusterMembers(ObservedClusterMembers observedClusterMembers, HighAvailabilityMemberStateMachine stateMachine) {
        this.observedClusterMembers = observedClusterMembers;
        this.stateMachine = stateMachine;
    }

    public ClusterMember getCurrentMember() {
        ClusterMember currentMember = this.observedClusterMembers.getCurrentMember();
        if (currentMember == null) {
            return null;
        }
        HighAvailabilityMemberState currentState = this.stateMachine.getCurrentState();
        return ClusterMembers.updateRole(currentMember, currentState);
    }

    public String getCurrentMemberRole() {
        ClusterMember currentMember = this.getCurrentMember();
        return currentMember == null ? "UNKNOWN" : currentMember.getHARole();
    }

    public Iterable<ClusterMember> getMembers() {
        return this.getActualMembers(this.observedClusterMembers.getMembers());
    }

    public Iterable<ClusterMember> getAliveMembers() {
        return this.getActualMembers(this.observedClusterMembers.getAliveMembers());
    }

    private Iterable<ClusterMember> getActualMembers(Iterable<ClusterMember> members) {
        final ClusterMember currentMember = this.getCurrentMember();
        if (currentMember == null) {
            return members;
        }
        return Iterables.map((Function)new Function<ClusterMember, ClusterMember>(){

            public ClusterMember apply(ClusterMember member) throws RuntimeException {
                return currentMember.getInstanceId().equals((Object)member.getInstanceId()) ? currentMember : member;
            }
        }, members);
    }

    private static ClusterMember updateRole(ClusterMember member, HighAvailabilityMemberState state) {
        switch (state) {
            case MASTER: {
                return member.availableAs("master", member.getHAUri(), member.getStoreId());
            }
            case SLAVE: {
                return member.availableAs("slave", member.getHAUri(), member.getStoreId());
            }
        }
        return member.unavailable();
    }
}

