/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.function.IntFunction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.ha.ClusterRule;

public class TestPullUpdates {
    private static final int PULL_INTERVAL = 100;
    private static final int SHELL_PORT = 6370;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass());

    @Test
    public void makeSureUpdatePullerGetsGoingAfterMasterSwitch() throws Throwable {
        ClusterManager.ManagedCluster cluster = ((ClusterRule)((ClusterRule)((ClusterRule)this.clusterRule.withSharedSetting(HaSettings.pull_interval, "100ms")).withSharedSetting(ClusterSettings.heartbeat_interval, "2s")).withSharedSetting(ClusterSettings.heartbeat_timeout, "30s")).startCluster();
        cluster.info("### Creating initial dataset");
        long commonNodeId = this.createNodeOnMaster(cluster);
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        this.setProperty(master, commonNodeId, 1);
        cluster.info("### Initial dataset created");
        this.awaitPropagation(1, commonNodeId, cluster, new HighlyAvailableGraphDatabase[0]);
        cluster.info("### Shutting down master");
        ClusterManager.RepairKit masterShutdownRK = cluster.shutdown(master);
        cluster.info("### Awaiting new master");
        cluster.await(ClusterManager.masterAvailable(master));
        cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        cluster.info("### Doing a write to master");
        this.setProperty(cluster.getMaster(), commonNodeId, 2);
        this.awaitPropagation(2, commonNodeId, cluster, master);
        cluster.info("### Repairing cluster");
        masterShutdownRK.repair();
        cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        cluster.info("### Awaiting change propagation");
        this.awaitPropagation(2, commonNodeId, cluster, new HighlyAvailableGraphDatabase[0]);
    }

    @Test
    public void terminatedTransactionDoesNotForceUpdatePullingWithTxTerminationAwareLocks() throws Throwable {
        int testTxsOnMaster = 42;
        ClusterManager.ManagedCluster cluster = ((ClusterRule)((ClusterRule)((ClusterRule)this.clusterRule.withSharedSetting(HaSettings.pull_interval, "0s")).withSharedSetting(HaSettings.tx_push_factor, "0")).withSharedSetting(KernelTransactions.tx_termination_aware_locks, "true")).startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        final HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        TestPullUpdates.createNodeOn((GraphDatabaseService)master);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        long lastClosedTxIdOnMaster = this.lastClosedTxIdOn((GraphDatabaseAPI)master);
        long lastClosedTxIdOnSlave = this.lastClosedTxIdOn((GraphDatabaseAPI)slave);
        final CountDownLatch slaveTxStarted = new CountDownLatch(1);
        final CountDownLatch slaveShouldCommit = new CountDownLatch(1);
        final AtomicReference slaveTx = new AtomicReference();
        Future<?> slaveCommit = Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try (Transaction tx = slave.beginTx();){
                    slaveTx.set(tx);
                    slaveTxStarted.countDown();
                    TestPullUpdates.this.await(slaveShouldCommit);
                    tx.success();
                }
            }
        });
        this.await(slaveTxStarted);
        TestPullUpdates.createNodesOn((GraphDatabaseService)master, testTxsOnMaster);
        Assert.assertNotNull(slaveTx.get());
        ((Transaction)slaveTx.get()).terminate();
        slaveShouldCommit.countDown();
        try {
            slaveCommit.get();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(ExecutionException.class));
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(TransientTransactionFailureException.class));
        }
        Assert.assertEquals((long)(lastClosedTxIdOnMaster + (long)testTxsOnMaster), (long)this.lastClosedTxIdOn((GraphDatabaseAPI)master));
        Assert.assertEquals((long)lastClosedTxIdOnSlave, (long)this.lastClosedTxIdOn((GraphDatabaseAPI)slave));
    }

    @Test
    public void pullUpdatesShellAppPullsUpdates() throws Throwable {
        ClusterManager.ManagedCluster cluster = ((ClusterRule)((ClusterRule)((ClusterRule)((ClusterRule)this.clusterRule.withProvider(ClusterManager.clusterOfSize(2)).withSharedSetting(HaSettings.pull_interval, "0")).withSharedSetting(HaSettings.tx_push_factor, "0")).withSharedSetting(ShellSettings.remote_shell_enabled, "true")).withInstanceSetting(ShellSettings.remote_shell_port, (IntFunction)new IntFunction<String>(){

            public String apply(int oneBasedServerId) {
                return oneBasedServerId >= 1 && oneBasedServerId <= 2 ? "" + (6370 + oneBasedServerId) : null;
            }
        })).startCluster();
        long commonNodeId = this.createNodeOnMaster(cluster);
        this.setProperty(cluster.getMaster(), commonNodeId, 1);
        this.callPullUpdatesViaShell(2);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = slave.beginTx();){
            Assert.assertEquals((Object)1, (Object)slave.getNodeById(commonNodeId).getProperty("i"));
            tx.success();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldPullUpdatesOnStartupNoMatterWhat() throws Exception {
        HighlyAvailableGraphDatabase slave = null;
        HighlyAvailableGraphDatabase master = null;
        try {
            long nodeId;
            File testRootDir = this.clusterRule.cleanDirectory("shouldPullUpdatesOnStartupNoMatterWhat");
            File masterDir = new File(testRootDir, "master");
            master = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(masterDir).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.initial_hosts, "localhost:5001").newGraphDatabase();
            File slaveDir = new File(testRootDir, "slave");
            slave = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(slaveDir).setConfig(ClusterSettings.server_id, "2").setConfig(ClusterSettings.initial_hosts, "localhost:5001").newGraphDatabase();
            final CountDownLatch slaveLeftLatch = new CountDownLatch(1);
            final ClusterClient masterClusterClient = (ClusterClient)master.getDependencyResolver().resolveDependency(ClusterClient.class);
            masterClusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){

                public void leftCluster(InstanceId instanceId, URI member) {
                    slaveLeftLatch.countDown();
                    masterClusterClient.removeClusterListener((ClusterListener)this);
                }
            });
            ((LogService)master.getDependencyResolver().resolveDependency(LogService.class)).getInternalLog(this.getClass()).info("SHUTTING DOWN SLAVE");
            slave.shutdown();
            slave = null;
            Assert.assertTrue((String)"Timeout waiting for slave to leave", (boolean)slaveLeftLatch.await(60L, TimeUnit.SECONDS));
            try (Transaction tx = master.beginTx();){
                Node node = master.createNode();
                node.setProperty("from", (Object)"master");
                nodeId = node.getId();
                tx.success();
            }
            slave = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(slaveDir).setConfig(ClusterSettings.server_id, "2").setConfig(ClusterSettings.initial_hosts, "localhost:5001").setConfig(HaSettings.pull_interval, "0").newGraphDatabase();
            slave.beginTx().close();
            tx = slave.beginTx();
            var11_9 = null;
            try {
                Assert.assertEquals((Object)"master", (Object)slave.getNodeById(nodeId).getProperty("from"));
                tx.success();
            }
            catch (Throwable throwable) {
                var11_9 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var11_9 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            var11_9.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            if (slave != null) {
                slave.shutdown();
            }
            if (master != null) {
                master.shutdown();
            }
        }
    }

    private long createNodeOnMaster(ClusterManager.ManagedCluster cluster) {
        return TestPullUpdates.createNodeOn((GraphDatabaseService)cluster.getMaster());
    }

    private static void createNodesOn(GraphDatabaseService db, int count) {
        for (int i = 0; i < count; ++i) {
            TestPullUpdates.createNodeOn(db);
        }
    }

    private static long createNodeOn(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            long id = db.createNode().getId();
            tx.success();
            long l = id;
            return l;
        }
    }

    private void callPullUpdatesViaShell(int i) throws ShellException {
        ShellClient client = ShellLobby.newClient((int)(6370 + i));
        client.evaluate("pullupdates");
    }

    private void powerNap() throws InterruptedException {
        Thread.sleep(50L);
    }

    private void awaitPropagation(int expectedPropertyValue, long nodeId, ClusterManager.ManagedCluster cluster, HighlyAvailableGraphDatabase ... excepts) throws Exception {
        long endTime = System.currentTimeMillis() + 2000L;
        boolean ok = false;
        while (!ok && System.currentTimeMillis() < endTime) {
            ok = true;
            block12: for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
                for (HighlyAvailableGraphDatabase except : excepts) {
                    if (db == except) continue block12;
                }
                try {
                    Transaction tx = db.beginTx();
                    Throwable throwable = null;
                    try {
                        Number value = (Number)db.getNodeById(nodeId).getProperty("i", null);
                        if (value != null && value.intValue() == expectedPropertyValue) continue;
                        ok = false;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                catch (NotFoundException e) {
                    ok = false;
                }
            }
            if (ok) continue;
            this.powerNap();
        }
        Assert.assertTrue((String)"Change wasn't propagated by pulling updates", (boolean)ok);
    }

    private void setProperty(HighlyAvailableGraphDatabase db, long nodeId, int i) throws Exception {
        try (Transaction tx = db.beginTx();){
            db.getNodeById(nodeId).setProperty("i", (Object)i);
            tx.success();
        }
    }

    private void await(CountDownLatch latch) {
        try {
            Assert.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private long lastClosedTxIdOn(GraphDatabaseAPI db) {
        TransactionIdStore txIdStore = (TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        return txIdStore.getLastClosedTransactionId();
    }
}

