/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.correctness;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.function.Predicate;
import org.neo4j.ha.correctness.ClusterAction;
import org.neo4j.ha.correctness.ClusterInstance;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;

class ClusterState {
    public static final Predicate<ClusterInstance> HAS_TIMEOUTS = new Predicate<ClusterInstance>(){

        public boolean test(ClusterInstance item) {
            return item.hasPendingTimeouts();
        }
    };
    private final Set<ClusterAction> pendingActions;
    private final List<ClusterInstance> instances = new ArrayList<ClusterInstance>();

    public ClusterState(List<ClusterInstance> instances, Set<ClusterAction> pendingActions) {
        this.pendingActions = pendingActions instanceof LinkedHashSet ? pendingActions : new LinkedHashSet(pendingActions);
        for (ClusterInstance instance : instances) {
            this.instances.add(instance);
        }
    }

    public void addPendingActions(ClusterAction ... actions) {
        for (ClusterAction action : actions) {
            this.pendingActions.add(action);
        }
    }

    public Iterator<Pair<ClusterAction, ClusterState>> transitions() {
        final Iterator<ClusterAction> actions = this.pendingActions.iterator();
        final Iterator instancesWithTimeouts = Iterables.filter(HAS_TIMEOUTS, this.instances).iterator();
        return new PrefetchingIterator<Pair<ClusterAction, ClusterState>>(){

            protected Pair<ClusterAction, ClusterState> fetchNextOrNull() {
                try {
                    if (actions.hasNext()) {
                        ClusterAction action = (ClusterAction)actions.next();
                        return Pair.of((Object)action, (Object)ClusterState.this.performAction(action));
                    }
                    if (instancesWithTimeouts.hasNext()) {
                        ClusterInstance instance = (ClusterInstance)instancesWithTimeouts.next();
                        return ClusterState.this.performNextTimeoutFrom(instance);
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private Pair<ClusterAction, ClusterState> performNextTimeoutFrom(ClusterInstance instance) throws Exception {
        ClusterState newState = this.snapshot();
        ClusterAction clusterAction = newState.instance(instance.uri().toASCIIString()).popTimeout();
        clusterAction.perform(newState);
        return Pair.of((Object)clusterAction, (Object)newState);
    }

    ClusterState performAction(ClusterAction action) throws Exception {
        ClusterState newState = this.snapshot();
        newState.pendingActions.remove(action);
        Iterable<ClusterAction> newActions = action.perform(newState);
        newState.pendingActions.addAll(IteratorUtil.asCollection(newActions));
        return newState;
    }

    public ClusterState snapshot() {
        LinkedHashSet<ClusterAction> newPendingActions = new LinkedHashSet<ClusterAction>(this.pendingActions);
        ArrayList<ClusterInstance> cloneInstances = new ArrayList<ClusterInstance>();
        for (ClusterInstance clusterInstance : this.instances) {
            cloneInstances.add(clusterInstance.newCopy());
        }
        return new ClusterState(cloneInstances, newPendingActions);
    }

    public ClusterInstance instance(String to) throws URISyntaxException {
        URI uri = new URI(to);
        for (ClusterInstance clusterInstance : this.instances) {
            URI instanceUri = clusterInstance.uri();
            if (!instanceUri.getHost().equals(uri.getHost()) || instanceUri.getPort() != uri.getPort()) continue;
            return clusterInstance;
        }
        throw new IllegalArgumentException("No instance in cluster at address: " + to);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterState that = (ClusterState)o;
        if (!this.instances.equals(that.instances)) {
            return false;
        }
        return this.pendingActions.equals(that.pendingActions);
    }

    public int hashCode() {
        int result = this.instances.hashCode();
        result = 31 * result + this.pendingActions.hashCode();
        return result;
    }

    public String toString() {
        return "Cluster[" + Iterables.toString(this.instances, (String)", ") + "]";
    }

    public boolean isDeadEnd() {
        if (this.pendingActions.size() > 0) {
            return false;
        }
        for (ClusterInstance instance : this.instances) {
            if (!instance.hasPendingTimeouts()) continue;
            return false;
        }
        return true;
    }
}

