/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.register.Registers;
import org.neo4j.test.ha.ClusterRule;

public class HACountsPropagationTest {
    private static final int PULL_INTERVAL = 100;
    @Rule
    public ClusterRule clusterRule = new ClusterRule(this.getClass()).withSharedSetting(HaSettings.pull_interval, "100ms");

    @Test
    public void shouldPropagateNodeCountsInHA() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            master.createNode();
            master.createNode(new Label[]{DynamicLabel.label((String)"A")});
            tx.success();
        }
        this.waitForPullUpdates();
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
            CountsTracker counts = ((NeoStores)db.getDependencyResolver().resolveDependency(NeoStores.class)).getCounts();
            Assert.assertEquals((long)2L, (long)counts.nodeCount(-1, Registers.newDoubleLongRegister()).readSecond());
            Assert.assertEquals((long)1L, (long)counts.nodeCount(0, Registers.newDoubleLongRegister()).readSecond());
        }
    }

    @Test
    public void shouldPropagateRelationshipCountsInHA() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            Node left = master.createNode();
            Node right = master.createNode(new Label[]{DynamicLabel.label((String)"A")});
            left.createRelationshipTo(right, (RelationshipType)DynamicRelationshipType.withName((String)"Type"));
            tx.success();
        }
        this.waitForPullUpdates();
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
            CountsTracker counts = ((NeoStores)db.getDependencyResolver().resolveDependency(NeoStores.class)).getCounts();
            Assert.assertEquals((long)1L, (long)counts.relationshipCount(-1, -1, -1, Registers.newDoubleLongRegister()).readSecond());
            Assert.assertEquals((long)1L, (long)counts.relationshipCount(-1, -1, 0, Registers.newDoubleLongRegister()).readSecond());
            Assert.assertEquals((long)1L, (long)counts.relationshipCount(-1, 0, -1, Registers.newDoubleLongRegister()).readSecond());
            Assert.assertEquals((long)1L, (long)counts.relationshipCount(-1, 0, 0, Registers.newDoubleLongRegister()).readSecond());
        }
    }

    private void waitForPullUpdates() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

