/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.factory;

import java.lang.reflect.Proxy;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.CommitProcessSwitcher;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.ModeSwitcherNotifier;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.factory.HighlyAvailableCommitProcessFactory;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.impl.api.ReadOnlyTransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.state.NeoStoreInjectedTransactionValidator;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class HighlyAvailableCommitProcessFactoryTest {
    @Test
    public void createReadOnlyCommitProcess() {
        HighlyAvailableCommitProcessFactory factory = new HighlyAvailableCommitProcessFactory((LifeSupport)Mockito.mock(LifeSupport.class), (Master)Mockito.mock(Master.class), (TransactionPropagator)Mockito.mock(TransactionPropagator.class), (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (HighAvailabilityModeSwitcher)Mockito.mock(HighAvailabilityModeSwitcher.class));
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"}));
        TransactionCommitProcess commitProcess = factory.create((TransactionAppender)Mockito.mock(TransactionAppender.class), (TransactionRepresentationStoreApplier)Mockito.mock(TransactionRepresentationStoreApplier.class), (NeoStoreInjectedTransactionValidator)Mockito.mock(NeoStoreInjectedTransactionValidator.class), (IndexUpdatesValidator)Mockito.mock(IndexUpdatesValidator.class), config);
        Assert.assertThat((Object)commitProcess, (Matcher)Matchers.instanceOf(ReadOnlyTransactionCommitProcess.class));
    }

    @Test
    public void createRegularCommitProcess() {
        LifeSupport modeSwitchersLife = (LifeSupport)Mockito.mock(LifeSupport.class);
        Mockito.when((Object)modeSwitchersLife.getLifecycleInstances()).thenReturn((Object)Iterables.empty());
        HighlyAvailableCommitProcessFactory factory = new HighlyAvailableCommitProcessFactory(modeSwitchersLife, (Master)Mockito.mock(Master.class), (TransactionPropagator)Mockito.mock(TransactionPropagator.class), (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (HighAvailabilityModeSwitcher)Mockito.mock(HighAvailabilityModeSwitcher.class));
        TransactionCommitProcess commitProcess = factory.create((TransactionAppender)Mockito.mock(TransactionAppender.class), (TransactionRepresentationStoreApplier)Mockito.mock(TransactionRepresentationStoreApplier.class), (NeoStoreInjectedTransactionValidator)Mockito.mock(NeoStoreInjectedTransactionValidator.class), (IndexUpdatesValidator)Mockito.mock(IndexUpdatesValidator.class), new Config());
        Assert.assertThat((Object)commitProcess, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(ReadOnlyTransactionCommitProcess.class)));
        Assert.assertThat((Object)Proxy.getInvocationHandler(commitProcess), (Matcher)Matchers.instanceOf(DelegateInvocationHandler.class));
    }

    @Test
    public void removesOldCommitProcessSwitcherFromLifeWhenNewOneIsCreated() throws Throwable {
        CommitProcessSwitcher oldCommitSwitcher1 = this.newCommitProcessSwitcher();
        CommitProcessSwitcher oldCommitSwitcher2 = this.newCommitProcessSwitcher();
        LifeSupport life = new LifeSupport();
        life.add((Lifecycle)oldCommitSwitcher1);
        life.add((Lifecycle)oldCommitSwitcher2);
        HighlyAvailableCommitProcessFactory factory = new HighlyAvailableCommitProcessFactory(life, (Master)Mockito.mock(Master.class), (TransactionPropagator)Mockito.mock(TransactionPropagator.class), (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (HighAvailabilityModeSwitcher)Mockito.mock(HighAvailabilityModeSwitcher.class));
        TransactionCommitProcess commitProcess = factory.create((TransactionAppender)Mockito.mock(TransactionAppender.class), (TransactionRepresentationStoreApplier)Mockito.mock(TransactionRepresentationStoreApplier.class), (NeoStoreInjectedTransactionValidator)Mockito.mock(NeoStoreInjectedTransactionValidator.class), (IndexUpdatesValidator)Mockito.mock(IndexUpdatesValidator.class), new Config());
        Assert.assertNotNull((Object)commitProcess);
        List lifecycle = Iterables.toList((Iterable)life.getLifecycleInstances());
        Assert.assertEquals((long)1L, (long)lifecycle.size());
        Assert.assertFalse((boolean)lifecycle.contains(oldCommitSwitcher1));
        Assert.assertFalse((boolean)lifecycle.contains(oldCommitSwitcher2));
    }

    private CommitProcessSwitcher newCommitProcessSwitcher() {
        return new CommitProcessSwitcher((TransactionPropagator)Mockito.mock(TransactionPropagator.class), (Master)Mockito.mock(Master.class), (DelegateInvocationHandler)Mockito.mock(DelegateInvocationHandler.class), (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (ModeSwitcherNotifier)Mockito.mock(ModeSwitcherNotifier.class), (NeoStoreInjectedTransactionValidator)Mockito.mock(NeoStoreInjectedTransactionValidator.class), (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class));
    }
}

