/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.util.Map;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.factory.HighlyAvailableEditionModule;
import org.neo4j.kernel.ha.factory.HighlyAvailableFacadeFactory;
import org.neo4j.kernel.impl.factory.DataSourceModule;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.monitoring.Monitors;

public class HighlyAvailableGraphDatabase
extends GraphDatabaseFacade {
    private HighlyAvailableEditionModule highlyAvailableEditionModule;

    public HighlyAvailableGraphDatabase(File storeDir, Map<String, String> params, Iterable<KernelExtensionFactory<?>> kernelExtensions, Monitors monitors) {
        this(storeDir, params, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies().settingsClasses(new Class[]{GraphDatabaseSettings.class, ClusterSettings.class, HaSettings.class}).kernelExtensions(kernelExtensions).monitors(monitors));
    }

    public HighlyAvailableGraphDatabase(File storeDir, Map<String, String> params, Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        this(storeDir, params, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies().settingsClasses(new Class[]{GraphDatabaseSettings.class, ClusterSettings.class, HaSettings.class}).kernelExtensions(kernelExtensions));
    }

    public HighlyAvailableGraphDatabase(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        this.newHighlyAvailableFacadeFactory().newFacade(storeDir, params, dependencies, this);
    }

    protected HighlyAvailableFacadeFactory newHighlyAvailableFacadeFactory() {
        return new HighlyAvailableFacadeFactory();
    }

    public void init(PlatformModule platformModule, EditionModule editionModule, DataSourceModule dataSourceModule) {
        super.init(platformModule, editionModule, dataSourceModule);
        this.highlyAvailableEditionModule = (HighlyAvailableEditionModule)editionModule;
    }

    public HighAvailabilityMemberState getInstanceState() {
        return this.highlyAvailableEditionModule.memberStateMachine.getCurrentState();
    }

    public String role() {
        return this.highlyAvailableEditionModule.members.getCurrentMemberRole();
    }

    public boolean isMaster() {
        return "master".equals(this.role());
    }

    public File getStoreDirectory() {
        return this.storeDir;
    }
}

