/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ObservedClusterMembers {
    private static final Predicate<ClusterMember> ALIVE = new Predicate<ClusterMember>(){

        public boolean accept(ClusterMember item) {
            return item.isAlive();
        }
    };
    private final Log log;
    private final InstanceId me;
    private final Map<InstanceId, ClusterMember> members = new CopyOnWriteHashMap();

    public ObservedClusterMembers(LogProvider logProvider, Cluster cluster, Heartbeat heartbeat, ClusterMemberEvents events, InstanceId me) {
        this.me = me;
        this.log = logProvider.getLog(this.getClass());
        cluster.addClusterListener((ClusterListener)new HAMClusterListener());
        heartbeat.addHeartbeatListener((HeartbeatListener)new HAMHeartbeatListener());
        events.addClusterMemberListener((ClusterMemberListener)new HAMClusterMemberListener());
    }

    public Iterable<ClusterMember> getMembers() {
        return this.members.values();
    }

    public Iterable<ClusterMember> getAliveMembers() {
        return Iterables.filter(ALIVE, this.members.values());
    }

    public ClusterMember getCurrentMember() {
        for (ClusterMember clusterMember : this.getMembers()) {
            if (!clusterMember.getInstanceId().equals((Object)this.me)) continue;
            return clusterMember;
        }
        return null;
    }

    private ClusterMember getMember(InstanceId server) {
        ClusterMember clusterMember = this.members.get(server);
        if (clusterMember == null) {
            throw new IllegalStateException("Member " + server + " not found in " + new HashMap<InstanceId, ClusterMember>(this.members));
        }
        return clusterMember;
    }

    private class HAMHeartbeatListener
    extends HeartbeatListener.Adapter {
        private HAMHeartbeatListener() {
        }

        public void failed(InstanceId server) {
            if (ObservedClusterMembers.this.members.containsKey(server)) {
                ObservedClusterMembers.this.members.put(server, ObservedClusterMembers.this.getMember(server).failed());
            }
        }

        public void alive(InstanceId server) {
            if (ObservedClusterMembers.this.members.containsKey(server)) {
                ObservedClusterMembers.this.members.put(server, ObservedClusterMembers.this.getMember(server).alive());
            }
        }
    }

    private class HAMClusterMemberListener
    extends ClusterMemberListener.Adapter {
        private InstanceId masterId = null;

        private HAMClusterMemberListener() {
        }

        public void coordinatorIsElected(InstanceId coordinatorId) {
            if (coordinatorId.equals((Object)this.masterId)) {
                return;
            }
            this.masterId = coordinatorId;
            HashMap newMembers = new HashMap();
            for (Map.Entry memberEntry : ObservedClusterMembers.this.members.entrySet()) {
                newMembers.put(memberEntry.getKey(), ((ClusterMember)memberEntry.getValue()).unavailableAs("master").unavailableAs("slave"));
            }
            ObservedClusterMembers.this.members.clear();
            ObservedClusterMembers.this.members.putAll(newMembers);
        }

        public void memberIsAvailable(String role, InstanceId instanceId, URI roleUri, StoreId storeId) {
            ObservedClusterMembers.this.members.put(instanceId, ObservedClusterMembers.this.getMember(instanceId).availableAs(role, roleUri, storeId));
        }

        public void memberIsUnavailable(String role, InstanceId unavailableId) {
            try {
                ClusterMember member = ObservedClusterMembers.this.getMember(unavailableId);
                ObservedClusterMembers.this.members.put(unavailableId, member.unavailableAs(role));
            }
            catch (IllegalStateException e) {
                ObservedClusterMembers.this.log.warn("Unknown member with id '" + unavailableId + "' reported unavailable as '" + role + "'");
            }
        }

        public void memberIsFailed(InstanceId instanceId) {
            ClusterMember member = ObservedClusterMembers.this.getMember(instanceId);
            for (String role : member.getRoles()) {
                member = member.unavailableAs(role);
            }
            ObservedClusterMembers.this.members.put(instanceId, member);
        }
    }

    private class HAMClusterListener
    extends ClusterListener.Adapter {
        private HAMClusterListener() {
        }

        public void enteredCluster(ClusterConfiguration configuration) {
            HashMap<InstanceId, ClusterMember> newMembers = new HashMap<InstanceId, ClusterMember>();
            for (InstanceId memberClusterId : configuration.getMemberIds()) {
                newMembers.put(memberClusterId, new ClusterMember(memberClusterId));
            }
            ObservedClusterMembers.this.members.clear();
            ObservedClusterMembers.this.members.putAll(newMembers);
        }

        public void leftCluster() {
            ObservedClusterMembers.this.members.clear();
        }

        public void joinedCluster(InstanceId member, URI memberUri) {
            ObservedClusterMembers.this.members.put(member, new ClusterMember(member));
        }

        public void leftCluster(InstanceId instanceId, URI member) {
            ObservedClusterMembers.this.members.remove(instanceId);
        }
    }
}

