/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.slave;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.ComExceptionHandler;
import org.neo4j.com.Deserializer;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.ha.MasterClient214;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.LockStatus;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.util.HexPrinter;

public interface MasterClient
extends Master {
    public static final ObjectSerializer<LockResult> LOCK_SERIALIZER = new ObjectSerializer<LockResult>(){

        public void write(LockResult responseObject, ChannelBuffer result) throws IOException {
            result.writeByte(responseObject.getStatus().ordinal());
            if (responseObject.getStatus().hasMessage()) {
                Protocol.writeString((ChannelBuffer)result, (String)responseObject.getDeadlockMessage());
            }
        }
    };
    public static final Deserializer<LockResult> LOCK_RESULT_DESERIALIZER = new Deserializer<LockResult>(){

        public LockResult read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
            LockStatus status;
            byte statusOrdinal = buffer.readByte();
            try {
                status = LockStatus.values()[statusOrdinal];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                int maxBytesToPrint = 40960;
                throw (ArrayIndexOutOfBoundsException)Exceptions.withMessage((Throwable)e, (String)String.format("%s | read invalid ordinal %d. First %db of this channel buffer is:%n%s", e.getMessage(), statusOrdinal, maxBytesToPrint, this.beginningOfBufferAsHexString(buffer, maxBytesToPrint)));
            }
            return status.hasMessage() ? new LockResult(Protocol.readString((ChannelBuffer)buffer)) : new LockResult(status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String beginningOfBufferAsHexString(ChannelBuffer buffer, int maxBytesToPrint) {
            int prevIndex = buffer.readerIndex();
            buffer.readerIndex(0);
            try {
                ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(buffer.readableBytes());
                PrintStream stream = new PrintStream(byteArrayStream);
                HexPrinter printer = new HexPrinter(stream).withLineNumberDigits(4);
                for (int i = 0; buffer.readable() && i < maxBytesToPrint; ++i) {
                    printer.append(buffer.readByte());
                }
                stream.flush();
                String string = byteArrayStream.toString();
                return string;
            }
            finally {
                buffer.readerIndex(prevIndex);
            }
        }
    };
    public static final ProtocolVersion CURRENT = MasterClient214.PROTOCOL_VERSION;

    @Override
    public Response<Integer> createRelationshipType(RequestContext var1, String var2);

    @Override
    public Response<Void> newLockSession(RequestContext var1);

    @Override
    public Response<Long> commit(RequestContext var1, TransactionRepresentation var2);

    @Override
    public Response<Void> pullUpdates(RequestContext var1);

    public Response<Void> pullUpdates(RequestContext var1, ResponseUnpacker.TxHandler var2);

    @Override
    public Response<Void> copyStore(RequestContext var1, StoreWriter var2);

    public void setComExceptionHandler(ComExceptionHandler var1);

    public ProtocolVersion getProtocolVersion();
}

