/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.correctness;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.ha.correctness.ClusterAction;
import org.neo4j.ha.correctness.ClusterState;
import org.neo4j.ha.correctness.GraphVizExporter;
import org.neo4j.helpers.Pair;
import org.neo4j.io.fs.FileUtils;

public class ProofDatabase {
    private final GraphDatabaseService gds;
    private final Map<ClusterState, Node> stateNodes = new HashMap<ClusterState, Node>();

    public ProofDatabase(String location) {
        File dbDir = new File(location);
        this.cleanDbDir(dbDir);
        this.gds = new GraphDatabaseFactory().newEmbeddedDatabase(dbDir.getPath());
    }

    public Node newState(ClusterState state) {
        try (Transaction tx = this.gds.beginTx();){
            Node node = this.gds.createNode(new Label[]{DynamicLabel.label((String)"State")});
            node.setProperty("description", (Object)state.toString());
            tx.success();
            this.stateNodes.put(state, node);
            Node node2 = node;
            return node2;
        }
    }

    public void newStateTransition(ClusterState originalState, Pair<ClusterAction, ClusterState> transition) {
        try (Transaction tx = this.gds.beginTx();){
            Node stateNode = this.stateNodes.get(originalState);
            Node subStateNode = this.newState((ClusterState)transition.other());
            Relationship msg = stateNode.createRelationshipTo(subStateNode, (RelationshipType)DynamicRelationshipType.withName((String)"MESSAGE"));
            msg.setProperty("description", (Object)((ClusterAction)transition.first()).toString());
            tx.success();
        }
    }

    private void cleanDbDir(File dbDir) {
        if (dbDir.exists()) {
            try {
                FileUtils.deleteRecursively((File)dbDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            dbDir.getParentFile().mkdirs();
        }
    }

    public void shutdown() {
        this.gds.shutdown();
    }

    public boolean isKnownState(ClusterState state) {
        return this.stateNodes.containsKey(state);
    }

    public long numberOfKnownStates() {
        return this.stateNodes.size();
    }

    public long id(ClusterState nextState) {
        return this.stateNodes.get(nextState).getId();
    }

    public void export(GraphVizExporter graphVizExporter) throws IOException {
        graphVizExporter.export(this.gds);
    }
}

