/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.TargetCaller;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.ToNetworkStoreWriter;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.monitoring.Monitors;

public enum HaRequestType210 implements RequestType<Master>
{
    ALLOCATE_IDS((TargetCaller)new TargetCaller<Master, IdAllocation>(){

        public Response<IdAllocation> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            IdType idType = IdType.values()[input.readByte()];
            return master.allocateIds(context, idType);
        }
    }, new ObjectSerializer<IdAllocation>(){

        public void write(IdAllocation idAllocation, ChannelBuffer result) throws IOException {
            IdRange idRange = idAllocation.getIdRange();
            result.writeInt(idRange.getDefragIds().length);
            for (long id : idRange.getDefragIds()) {
                result.writeLong(id);
            }
            result.writeLong(idRange.getRangeStart());
            result.writeInt(idRange.getRangeLength());
            result.writeLong(idAllocation.getHighestIdInUse());
            result.writeLong(idAllocation.getDefragCount());
        }
    }),
    CREATE_RELATIONSHIP_TYPE((TargetCaller)new TargetCaller<Master, Integer>(){

        public Response<Integer> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.createRelationshipType(context, Protocol.readString((ChannelBuffer)input));
        }
    }, Protocol.INTEGER_SERIALIZER),
    ACQUIRE_EXCLUSIVE_LOCK((TargetCaller)new AquireLockCall(){

        @Override
        protected Response<LockResult> lock(Master master, RequestContext context, Locks.ResourceType type, long ... ids) {
            return master.acquireExclusiveLock(context, type, ids);
        }
    }, (ObjectSerializer)MasterClient.LOCK_SERIALIZER){

        @Override
        public boolean isLock() {
            return true;
        }
    }
    ,
    ACQUIRE_SHARED_LOCK((TargetCaller)new AquireLockCall(){

        @Override
        protected Response<LockResult> lock(Master master, RequestContext context, Locks.ResourceType type, long ... ids) {
            return master.acquireSharedLock(context, type, ids);
        }
    }, (ObjectSerializer)MasterClient.LOCK_SERIALIZER){

        @Override
        public boolean isLock() {
            return true;
        }
    }
    ,
    COMMIT((TargetCaller)new TargetCaller<Master, Long>(){

        public Response<Long> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) throws IOException, TransactionFailureException {
            Protocol.readString((ChannelBuffer)input);
            TransactionRepresentation tx = null;
            try {
                tx = (TransactionRepresentation)Protocol.TRANSACTION_REPRESENTATION_DESERIALIZER.read(input, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return master.commit(context, tx);
        }
    }, Protocol.LONG_SERIALIZER),
    PULL_UPDATES((TargetCaller)new TargetCaller<Master, Void>(){

        public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.pullUpdates(context);
        }
    }, Protocol.VOID_SERIALIZER),
    END_LOCK_SESSION((TargetCaller)new TargetCaller<Master, Void>(){

        public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.endLockSession(context, Protocol.readBoolean((ChannelBuffer)input));
        }
    }, Protocol.VOID_SERIALIZER){

        @Override
        public boolean responseShouldBeUnpacked() {
            return false;
        }
    }
    ,
    HANDSHAKE((TargetCaller)new TargetCaller<Master, HandshakeResult>(){

        public Response<HandshakeResult> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.handshake(input.readLong(), null);
        }
    }, new ObjectSerializer<HandshakeResult>(){

        public void write(HandshakeResult responseObject, ChannelBuffer result) throws IOException {
            result.writeLong(responseObject.txChecksum());
            result.writeLong(responseObject.epoch());
        }
    }),
    COPY_STORE((TargetCaller)new TargetCaller<Master, Void>(){

        public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.copyStore(context, (StoreWriter)new ToNetworkStoreWriter(target, new Monitors()));
        }
    }, Protocol.VOID_SERIALIZER){

        @Override
        public boolean responseShouldBeUnpacked() {
            return false;
        }
    }
    ,
    PLACEHOLDER_FOR_COPY_TRANSACTIONS((TargetCaller)new TargetCaller<Master, Void>(){

        public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            throw new UnsupportedOperationException("Not used anymore, merely here to keep the ordinal ids of the others");
        }
    }, Protocol.VOID_SERIALIZER),
    NEW_LOCK_SESSION((TargetCaller)new TargetCaller<Master, Void>(){

        public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) throws TransactionFailureException {
            return master.newLockSession(context);
        }
    }, Protocol.VOID_SERIALIZER),
    PLACEHOLDER_FOR_PUSH_TRANSACTION((TargetCaller)new TargetCaller<Master, Void>(){

        public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            throw new UnsupportedOperationException("Not used anymore, merely here to keep the ordinal ids of the others");
        }
    }, Protocol.VOID_SERIALIZER),
    CREATE_PROPERTY_KEY((TargetCaller)new TargetCaller<Master, Integer>(){

        public Response<Integer> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.createPropertyKey(context, Protocol.readString((ChannelBuffer)input));
        }
    }, Protocol.INTEGER_SERIALIZER),
    CREATE_LABEL((TargetCaller)new TargetCaller<Master, Integer>(){

        public Response<Integer> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            return master.createLabel(context, Protocol.readString((ChannelBuffer)input));
        }
    }, Protocol.INTEGER_SERIALIZER);

    final TargetCaller caller;
    final ObjectSerializer serializer;

    private <T> HaRequestType210(TargetCaller caller, ObjectSerializer<T> serializer) {
        this.caller = caller;
        this.serializer = serializer;
    }

    public ObjectSerializer getObjectSerializer() {
        return this.serializer;
    }

    public TargetCaller getTargetCaller() {
        return this.caller;
    }

    public byte id() {
        return (byte)this.ordinal();
    }

    public boolean responseShouldBeUnpacked() {
        return true;
    }

    public boolean isLock() {
        return false;
    }

    private static abstract class AquireLockCall
    implements TargetCaller<Master, LockResult> {
        private AquireLockCall() {
        }

        public Response<LockResult> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            Locks.ResourceType type = ResourceTypes.fromId((int)input.readInt());
            long[] ids = new long[input.readInt()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = input.readLong();
            }
            return this.lock(master, context, type, ids);
        }

        protected abstract Response<LockResult> lock(Master var1, RequestContext var2, Locks.ResourceType var3, long ... var4);
    }
}

