/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.Future;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.Barrier;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.OtherThreadRule;
import org.neo4j.test.ha.ClusterRule;

public class IdBufferingRoleSwitchIT {
    @Rule
    public ClusterRule clusterRule = ((ClusterRule)((ClusterRule)new ClusterRule(this.getClass()).withSharedSetting(HaSettings.pull_interval, "0")).withSharedSetting(HaSettings.tx_push_factor, "0")).withConsistencyCheckAfterwards();
    @Rule
    public OtherThreadRule<Void> t2 = new OtherThreadRule();

    @Test
    public void shouldNotSeeFreedIdsCrossRoleSwitch() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase firstMaster = cluster.getMaster();
        Node node = this.createNodeWithProperties((GraphDatabaseService)firstMaster, 1);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.deleteNode(node, (GraphDatabaseService)firstMaster);
        this.triggerIdMaintenance((GraphDatabaseAPI)firstMaster);
        this.createNodeWithProperties((GraphDatabaseService)firstMaster, 1);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Barrier.Control barrier = new Barrier.Control();
        Future t = this.t2.execute(this.barrierControlledReadTransaction((GraphDatabaseService)slave, barrier));
        barrier.await();
        ((UpdatePuller)slave.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
        cluster.shutdown(firstMaster);
        cluster.await(ClusterManager.masterAvailable(firstMaster));
        barrier.release();
        t.get();
        this.triggerIdMaintenance((GraphDatabaseAPI)slave);
        this.createNodeWithProperties((GraphDatabaseService)slave, 10);
        cluster.stop();
    }

    private void triggerIdMaintenance(GraphDatabaseAPI db) {
        ((NeoStoreDataSource.BufferedIdMaintenanceController)db.getDependencyResolver().resolveDependency(NeoStoreDataSource.BufferedIdMaintenanceController.class)).maintenance();
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> barrierControlledReadTransaction(final GraphDatabaseService slave, final Barrier.Control barrier) {
        return new OtherThreadExecutor.WorkerCommand<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void doWork(Void state) throws Exception {
                try (Transaction tx = slave.beginTx();){
                    barrier.reached();
                    tx.success();
                }
                catch (Exception exception) {
                }
                finally {
                    barrier.release();
                }
                return null;
            }
        };
    }

    private void deleteNode(Node node, GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            node.delete();
            tx.success();
        }
    }

    private Node createNodeWithProperties(GraphDatabaseService db, int numberOfProperties) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            for (int i = 0; i < numberOfProperties; ++i) {
                node.setProperty("key" + i, (Object)("value" + i));
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }
}

