/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.function.Supplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.ha.transaction.OnDiskLastTxIdGetter;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class OnDiskLastTxIdGetterTest {
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void testGetLastTxIdNoFilePresent() throws Exception {
        NeoStoresSupplier supplier = (NeoStoresSupplier)Mockito.mock(NeoStoresSupplier.class);
        NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
        MetaDataStore metaDataStore = (MetaDataStore)Mockito.mock(MetaDataStore.class);
        Mockito.when((Object)supplier.get()).thenReturn((Object)neoStores);
        Mockito.when((Object)neoStores.getMetaDataStore()).thenReturn((Object)metaDataStore);
        Mockito.when((Object)metaDataStore.getLastCommittedTransactionId()).thenReturn((Object)13L);
        OnDiskLastTxIdGetter getter = new OnDiskLastTxIdGetter((Supplier)supplier);
        Assert.assertEquals((long)13L, (long)getter.getLastTxId());
    }

    @Test
    public void lastTransactionIdIsBaseTxIdWhileNeoStoresAreStopped() {
        StoreFactory storeFactory = new StoreFactory((FileSystemAbstraction)this.fs.get(), new File("store"), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get()), (LogProvider)NullLogProvider.getInstance());
        final NeoStores neoStores = storeFactory.openAllNeoStores(true);
        neoStores.close();
        NeoStoresSupplier neoStoresSupplier = new NeoStoresSupplier(){

            public NeoStores get() {
                return neoStores;
            }
        };
        OnDiskLastTxIdGetter diskLastTxIdGetter = new OnDiskLastTxIdGetter((Supplier)neoStoresSupplier);
        Assert.assertEquals((long)1L, (long)diskLastTxIdGetter.getLastTxId());
    }
}

