/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.com.ComException;
import org.neo4j.function.Supplier;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.ModeSwitcher;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class HighAvailabilityModeSwitcherTest {
    @Test
    public void shouldBroadcastMasterIsAvailableIfMasterAndReceiveMasterIsElected() throws Exception {
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), availability, (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), (InstanceId)Mockito.mock(InstanceId.class), (LogService)NullLogService.getInstance(), HighAvailabilityModeSwitcherTest.neoStoreDataSourceSupplierMock());
        toTest.masterIsElected(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.MASTER, HighAvailabilityMemberState.MASTER, new InstanceId(2), URI.create("ha://someone")));
        ((ClusterMemberAvailability)Mockito.verify((Object)availability)).memberIsAvailable("master", null, StoreId.DEFAULT);
    }

    @Test
    public void shouldBroadcastSlaveIsAvailableIfSlaveAndReceivesMasterIsAvailable() throws Exception {
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), availability, (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), (InstanceId)Mockito.mock(InstanceId.class), (LogService)NullLogService.getInstance(), HighAvailabilityModeSwitcherTest.neoStoreDataSourceSupplierMock());
        toTest.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.SLAVE, HighAvailabilityMemberState.SLAVE, new InstanceId(2), URI.create("ha://someone")));
        ((ClusterMemberAvailability)Mockito.verify((Object)availability)).memberIsAvailable("slave", null, StoreId.DEFAULT);
    }

    @Test
    public void shouldNotBroadcastIfSlaveAndReceivesMasterIsElected() throws Exception {
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), availability, (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), (InstanceId)Mockito.mock(InstanceId.class), (LogService)NullLogService.getInstance(), HighAvailabilityModeSwitcherTest.neoStoreDataSourceSupplierMock());
        toTest.masterIsElected(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.SLAVE, HighAvailabilityMemberState.SLAVE, new InstanceId(2), URI.create("ha://someone")));
        Mockito.verifyZeroInteractions((Object[])new Object[]{availability});
    }

    @Test
    public void shouldNotBroadcastIfMasterAndReceivesSlaveIsAvailable() throws Exception {
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), availability, (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), (InstanceId)Mockito.mock(InstanceId.class), (LogService)NullLogService.getInstance(), HighAvailabilityModeSwitcherTest.neoStoreDataSourceSupplierMock());
        toTest.slaveIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.MASTER, HighAvailabilityMemberState.MASTER, new InstanceId(2), URI.create("ha://someone")));
        Mockito.verifyZeroInteractions((Object[])new Object[]{availability});
    }

    @Test
    public void shouldReswitchToSlaveIfNewMasterBecameElectedAndAvailableDuringSwitch() throws Throwable {
        final CountDownLatch switching = new CountDownLatch(1);
        final CountDownLatch slaveAvailable = new CountDownLatch(2);
        final AtomicBoolean firstSwitch = new AtomicBoolean(true);
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        SwitchToSlave switchToSlave = (SwitchToSlave)Mockito.mock(SwitchToSlave.class);
        SwitchToMaster switchToMaster = (SwitchToMaster)Mockito.mock(SwitchToMaster.class);
        Mockito.when((Object)switchToSlave.switchToSlave((LifeSupport)Matchers.any(LifeSupport.class), (URI)Matchers.any(URI.class), (URI)Matchers.any(URI.class), (CancellationRequest)Matchers.any(CancellationRequest.class))).thenAnswer((Answer)new Answer<URI>(){

            public URI answer(InvocationOnMock invocationOnMock) throws Throwable {
                switching.countDown();
                CancellationRequest cancel = (CancellationRequest)invocationOnMock.getArguments()[3];
                if (firstSwitch.get()) {
                    while (!cancel.cancellationRequested()) {
                        Thread.sleep(1L);
                    }
                    firstSwitch.set(false);
                }
                slaveAvailable.countDown();
                return URI.create("ha://slave");
            }
        });
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher(switchToSlave, switchToMaster, (Election)Mockito.mock(Election.class), availability, (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), (InstanceId)Mockito.mock(InstanceId.class), (LogService)NullLogService.getInstance(), HighAvailabilityModeSwitcherTest.neoStoreDataSourceSupplierMock());
        toTest.init();
        toTest.start();
        toTest.listeningAt(URI.create("ha://server3?serverId=3"));
        toTest.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_SLAVE, (InstanceId)Mockito.mock(InstanceId.class), URI.create("ha://server1")));
        switching.await();
        toTest.masterIsElected(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.TO_SLAVE, HighAvailabilityMemberState.PENDING, new InstanceId(2), URI.create("ha://server2")));
        toTest.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_SLAVE, new InstanceId(2), URI.create("ha://server2")));
        slaveAvailable.await();
    }

    @Test
    public void shouldRecognizeNewMasterIfNewMasterBecameAvailableDuringSwitch() throws Throwable {
        final CountDownLatch firstMasterAvailableHandled = new CountDownLatch(1);
        final CountDownLatch secondMasterAvailableComes = new CountDownLatch(1);
        final CountDownLatch secondMasterAvailableHandled = new CountDownLatch(1);
        SwitchToSlave switchToSlave = (SwitchToSlave)Mockito.mock(SwitchToSlave.class);
        HighAvailabilityModeSwitcher modeSwitcher = new HighAvailabilityModeSwitcher(switchToSlave, (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class), (ClusterClient)Mockito.mock(ClusterClient.class), (Supplier)Mockito.mock(Supplier.class), new InstanceId(4), (LogService)NullLogService.getInstance(), HighAvailabilityModeSwitcherTest.neoStoreDataSourceSupplierMock()){

            ScheduledExecutorService createExecutor() {
                ScheduledExecutorService executor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
                final ExecutorService realExecutor = Executors.newSingleThreadExecutor();
                Mockito.when(executor.submit((Runnable)Matchers.any(Runnable.class))).thenAnswer(new Answer<Future<?>>(){

                    public Future<?> answer(final InvocationOnMock invocation) throws Throwable {
                        return realExecutor.submit(new Runnable(){

                            @Override
                            public void run() {
                                ((Runnable)invocation.getArguments()[0]).run();
                            }
                        });
                    }
                });
                Mockito.when(executor.schedule((Runnable)Matchers.any(Runnable.class), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)))).thenAnswer(new Answer<Future<?>>(){

                    public Future<?> answer(final InvocationOnMock invocation) throws Throwable {
                        realExecutor.submit(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                firstMasterAvailableHandled.countDown();
                                secondMasterAvailableComes.await();
                                ((Runnable)invocation.getArguments()[0]).run();
                                secondMasterAvailableHandled.countDown();
                                return null;
                            }
                        });
                        return (Future)Mockito.mock(ScheduledFuture.class);
                    }
                });
                return executor;
            }
        };
        modeSwitcher.init();
        modeSwitcher.start();
        modeSwitcher.listeningAt(URI.create("ha://server3?serverId=3"));
        URI uri1 = URI.create("ha://server1");
        ((SwitchToSlave)Mockito.doThrow((Throwable)new ComException("Fail to switch to slave and reschedule to retry")).when((Object)switchToSlave)).switchToSlave((LifeSupport)Matchers.any(LifeSupport.class), (URI)Matchers.any(URI.class), (URI)Matchers.eq((Object)uri1), (CancellationRequest)Matchers.any(CancellationRequest.class));
        modeSwitcher.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_SLAVE, new InstanceId(1), uri1));
        firstMasterAvailableHandled.await();
        ((SwitchToSlave)Mockito.verify((Object)switchToSlave)).switchToSlave((LifeSupport)Matchers.any(LifeSupport.class), (URI)Matchers.any(URI.class), (URI)Matchers.eq((Object)uri1), (CancellationRequest)Matchers.any(CancellationRequest.class));
        URI uri2 = URI.create("ha://server2");
        modeSwitcher.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.TO_SLAVE, HighAvailabilityMemberState.TO_SLAVE, new InstanceId(2), uri2));
        secondMasterAvailableComes.countDown();
        secondMasterAvailableHandled.await();
        ((SwitchToSlave)Mockito.verify((Object)switchToSlave)).switchToSlave((LifeSupport)Matchers.any(LifeSupport.class), (URI)Matchers.any(URI.class), (URI)Matchers.eq((Object)uri2), (CancellationRequest)Matchers.any(CancellationRequest.class));
    }

    @Test
    public void shouldNotResetAvailableMasterURIIfElectionResultReceived() throws Throwable {
        SwitchToSlave switchToSlave = (SwitchToSlave)Mockito.mock(SwitchToSlave.class);
        final CountDownLatch firstCallMade = new CountDownLatch(1);
        final CountDownLatch secondCallMade = new CountDownLatch(1);
        final CountDownLatch waitForSecondMessage = new CountDownLatch(1);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher(switchToSlave, (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class), (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), new InstanceId(1), (LogService)NullLogService.getInstance(), HighAvailabilityModeSwitcherTest.neoStoreDataSourceSupplierMock());
        URI uri1 = URI.create("ha://server1");
        toTest.init();
        toTest.start();
        toTest.listeningAt(URI.create("ha://server3?serverId=3"));
        Mockito.when((Object)switchToSlave.switchToSlave((LifeSupport)Matchers.any(LifeSupport.class), (URI)Matchers.any(URI.class), (URI)Matchers.any(URI.class), (CancellationRequest)Matchers.any(CancellationRequest.class))).thenAnswer((Answer)new Answer<URI>(){

            public URI answer(InvocationOnMock invocation) throws Throwable {
                firstCallMade.countDown();
                waitForSecondMessage.await();
                throw new MismatchingStoreIdException(StoreId.DEFAULT, StoreId.DEFAULT);
            }
        }).thenAnswer((Answer)new Answer<URI>(){

            public URI answer(InvocationOnMock invocation) throws Throwable {
                secondCallMade.countDown();
                return URI.create("ha://server3");
            }
        });
        toTest.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_SLAVE, new InstanceId(1), uri1));
        firstCallMade.await();
        toTest.masterIsElected(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.TO_SLAVE, HighAvailabilityMemberState.TO_SLAVE, new InstanceId(1), null));
        waitForSecondMessage.countDown();
        secondCallMade.await();
        ((SwitchToSlave)Mockito.verify((Object)switchToSlave, (VerificationMode)Mockito.times((int)2))).switchToSlave((LifeSupport)Matchers.any(LifeSupport.class), (URI)Matchers.any(URI.class), (URI)Matchers.eq((Object)uri1), (CancellationRequest)Matchers.any(CancellationRequest.class));
    }

    @Test
    public void shouldTakeNoActionIfSwitchingToSlaveForItselfAsMaster() throws Throwable {
        SwitchToSlave switchToSlave = (SwitchToSlave)Mockito.mock(SwitchToSlave.class);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)logProvider);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher(switchToSlave, (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class), (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), new InstanceId(2), (LogService)logService, HighAvailabilityModeSwitcherTest.neoStoreDataSourceSupplierMock());
        toTest.init();
        toTest.start();
        URI serverHaUri = URI.create("ha://server2?serverId=2");
        toTest.listeningAt(serverHaUri);
        toTest.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_SLAVE, new InstanceId(2), serverHaUri));
        Mockito.verifyZeroInteractions((Object[])new Object[]{switchToSlave});
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(HighAvailabilityModeSwitcher.class).error("I (ha://server2?serverId=2) tried to switch to slave for myself as master (ha://server2?serverId=2)")});
    }

    @Test
    public void shouldPerformForcedElections() {
        ClusterMemberAvailability memberAvailability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityModeSwitcher modeSwitcher = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), election, memberAvailability, (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), (InstanceId)Mockito.mock(InstanceId.class), (LogService)NullLogService.getInstance(), HighAvailabilityModeSwitcherTest.neoStoreDataSourceSupplierMock());
        modeSwitcher.forceElections();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{memberAvailability, election});
        ((ClusterMemberAvailability)inOrder.verify((Object)memberAvailability)).memberIsUnavailable("slave");
        ((Election)inOrder.verify((Object)election)).performRoleElections();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldPerformForcedElectionsOnlyOnce() {
        ClusterMemberAvailability memberAvailability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityModeSwitcher modeSwitcher = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), election, memberAvailability, (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), (InstanceId)Mockito.mock(InstanceId.class), (LogService)NullLogService.getInstance(), HighAvailabilityModeSwitcherTest.neoStoreDataSourceSupplierMock());
        modeSwitcher.forceElections();
        modeSwitcher.forceElections();
        modeSwitcher.forceElections();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{memberAvailability, election});
        ((ClusterMemberAvailability)inOrder.verify((Object)memberAvailability)).memberIsUnavailable("slave");
        ((Election)inOrder.verify((Object)election)).performRoleElections();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAllowForcedElectionsAfterModeSwitch() throws Throwable {
        SwitchToSlave switchToSlave = (SwitchToSlave)Mockito.mock(SwitchToSlave.class);
        Mockito.when((Object)switchToSlave.switchToSlave((LifeSupport)Matchers.any(LifeSupport.class), (URI)Matchers.any(URI.class), (URI)Matchers.any(URI.class), (CancellationRequest)Matchers.any(CancellationRequest.class))).thenReturn((Object)URI.create("http://localhost"));
        ClusterMemberAvailability memberAvailability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        Election election = (Election)Mockito.mock(Election.class);
        final CountDownLatch modeSwitchHappened = new CountDownLatch(1);
        HighAvailabilityModeSwitcher modeSwitcher = new HighAvailabilityModeSwitcher(switchToSlave, (SwitchToMaster)Mockito.mock(SwitchToMaster.class), election, memberAvailability, (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), (InstanceId)Mockito.mock(InstanceId.class), (LogService)NullLogService.getInstance(), HighAvailabilityModeSwitcherTest.neoStoreDataSourceSupplierMock()){

            ScheduledExecutorService createExecutor() {
                ScheduledExecutorService executor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
                ((ScheduledExecutorService)Mockito.doAnswer((Answer)new Answer<Future<?>>(){

                    public Future<?> answer(InvocationOnMock invocation) throws Throwable {
                        ((Runnable)invocation.getArguments()[0]).run();
                        modeSwitchHappened.countDown();
                        return (Future)Mockito.mock(Future.class);
                    }
                }).when((Object)executor)).submit((Runnable)Matchers.any(Runnable.class));
                return executor;
            }
        };
        modeSwitcher.init();
        modeSwitcher.start();
        modeSwitcher.forceElections();
        Mockito.reset((Object[])new Object[]{memberAvailability, election});
        modeSwitcher.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_SLAVE, (InstanceId)Mockito.mock(InstanceId.class), URI.create("http://localhost:9090?serverId=42")));
        modeSwitchHappened.await();
        modeSwitcher.forceElections();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{memberAvailability, election});
        ((ClusterMemberAvailability)inOrder.verify((Object)memberAvailability)).memberIsUnavailable("slave");
        ((Election)inOrder.verify((Object)election)).performRoleElections();
        inOrder.verifyNoMoreInteractions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUseProperServerIdWhenDemotingFromMasterOnException() throws Throwable {
        SwitchToSlave sts = (SwitchToSlave)Mockito.mock(SwitchToSlave.class);
        SwitchToMaster stm = (SwitchToMaster)Mockito.mock(SwitchToMaster.class);
        Mockito.when((Object)stm.switchToMaster((LifeSupport)Matchers.any(LifeSupport.class), (URI)Matchers.any(URI.class))).thenThrow(new Throwable[]{new RuntimeException()});
        Election election = (Election)Mockito.mock(Election.class);
        ClusterMemberAvailability cma = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        InstanceId instanceId = new InstanceId(14);
        HighAvailabilityModeSwitcher theSwitcher = new HighAvailabilityModeSwitcher(sts, stm, election, cma, (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), instanceId, (LogService)NullLogService.getInstance(), HighAvailabilityModeSwitcherTest.neoStoreDataSourceSupplierMock());
        theSwitcher.init();
        theSwitcher.start();
        URI listeningAt = URI.create("ha://0.0.0.0:5001?name=someName");
        theSwitcher.listeningAt(listeningAt);
        try {
            theSwitcher.masterIsElected(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_MASTER, instanceId, listeningAt));
        }
        finally {
            theSwitcher.stop();
            theSwitcher.shutdown();
        }
        ((Election)Mockito.verify((Object)election)).demote(instanceId);
    }

    @Test
    public void shouldSwitchToSlaveForNullMasterAndBeSilentWhenMovingToDetached() throws Throwable {
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), availability, (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), (InstanceId)Mockito.mock(InstanceId.class), (LogService)NullLogService.getInstance(), HighAvailabilityModeSwitcherTest.neoStoreDataSourceSupplierMock());
        ModeSwitcher mockSwitcher = (ModeSwitcher)Mockito.mock(ModeSwitcher.class);
        toTest.addModeSwitcher(mockSwitcher);
        toTest.init();
        toTest.start();
        toTest.instanceDetached(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.MASTER, HighAvailabilityMemberState.PENDING, null, null));
        ((ModeSwitcher)Mockito.verify((Object)mockSwitcher)).switchToSlave();
        Mockito.verifyZeroInteractions((Object[])new Object[]{availability});
    }

    public static Supplier<StoreId> storeSupplierMock() {
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)supplier.get()).thenReturn((Object)StoreId.DEFAULT);
        return supplier;
    }

    public static DataSourceManager neoStoreDataSourceSupplierMock() {
        DataSourceManager dataSourceManager = new DataSourceManager();
        dataSourceManager.register((NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class));
        return dataSourceManager;
    }
}

