/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.InstanceId;
import org.neo4j.com.Response;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlavePriorities;
import org.neo4j.kernel.ha.com.master.SlavePriority;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.ha.transaction.CommitPusher;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;

public class TransactionPropagatorTest {
    @Rule
    public final LifeRule life = new LifeRule(true);

    @Test
    public void shouldCapUndesiredSlaveCountPushLogging() throws Exception {
        int serverId = 1;
        final InstanceId instanceId = new InstanceId(serverId);
        TransactionPropagator.Configuration config = new TransactionPropagator.Configuration(){

            public int getTxPushFactor() {
                return 1;
            }

            public InstanceId getServerId() {
                return instanceId;
            }

            public SlavePriority getReplicationStrategy() {
                return SlavePriorities.fixedDescending();
            }
        };
        Log logger = (Log)Mockito.mock(Log.class);
        Slaves slaves = (Slaves)Mockito.mock(Slaves.class);
        Mockito.when((Object)slaves.getSlaves()).thenReturn(Collections.emptyList());
        CommitPusher pusher = (CommitPusher)Mockito.mock(CommitPusher.class);
        TransactionPropagator propagator = (TransactionPropagator)this.life.add((Lifecycle)new TransactionPropagator(config, logger, slaves, pusher));
        for (int i = 0; i < 10; ++i) {
            propagator.committed(1L, serverId);
        }
        ((Log)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).info(Matchers.anyString());
    }

    @Test
    public void shouldPrioritizeAscendingIfAsked() throws Exception {
        TransactionPropagator.Configuration propagator = TransactionPropagator.from((Config)new Config(MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_strategy.name(), HaSettings.TxPushStrategy.fixed_ascending.name()})));
        SlavePriority strategy = propagator.getReplicationStrategy();
        Iterable prioritize = strategy.prioritize(Arrays.asList(this.slave(1), this.slave(0), this.slave(2)));
        Assert.assertThat((Object)Iterables.toList((Iterable)prioritize), (Matcher)IsEqual.equalTo(Arrays.asList(this.slave(0), this.slave(1), this.slave(2))));
    }

    @Test
    public void shouldPrioritizeDescendingIfAsked() throws Exception {
        TransactionPropagator.Configuration propagator = TransactionPropagator.from((Config)new Config(MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_strategy.name(), HaSettings.TxPushStrategy.fixed_descending.name()})));
        SlavePriority strategy = propagator.getReplicationStrategy();
        Iterable prioritize = strategy.prioritize(Arrays.asList(this.slave(1), this.slave(0), this.slave(2)));
        Assert.assertThat((Object)Iterables.toList((Iterable)prioritize), (Matcher)IsEqual.equalTo(Arrays.asList(this.slave(2), this.slave(1), this.slave(0))));
    }

    @Test
    public void shouldWorkWithOldFixedKeyword() throws Exception {
        TransactionPropagator.Configuration propagator = TransactionPropagator.from((Config)new Config(MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_strategy.name(), "fixed"}), new Class[]{HaSettings.class}));
        SlavePriority strategy = propagator.getReplicationStrategy();
        Iterable prioritize = strategy.prioritize(Arrays.asList(this.slave(1), this.slave(0), this.slave(2)));
        Assert.assertThat((Object)Iterables.toList((Iterable)prioritize), (Matcher)IsEqual.equalTo(Arrays.asList(this.slave(2), this.slave(1), this.slave(0))));
    }

    private Slave slave(final int id) {
        return new Slave(){

            public Response<Void> pullUpdates(long upToAndIncludingTxId) {
                throw new UnsupportedOperationException();
            }

            public int getServerId() {
                return id;
            }

            public boolean equals(Object obj) {
                return obj instanceof Slave && ((Slave)obj).getServerId() == id;
            }

            public int hashCode() {
                return id;
            }

            public String toString() {
                return "Slave[" + id + "]";
            }
        };
    }
}

