/*
 * Decompiled with CFR 0.152.
 */
package jmx;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.function.IntFunction;
import org.neo4j.function.Predicate;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.impl.JmxKernelExtension;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.management.BranchedStore;
import org.neo4j.management.ClusterMemberInfo;
import org.neo4j.management.HighAvailability;
import org.neo4j.management.Neo4jManager;
import org.neo4j.test.ha.ClusterRule;

public class HaBeanIT {
    @ClassRule
    public static final ClusterRule clusterRule = ((ClusterRule)((ClusterRule)new ClusterRule(HaBeanIT.class).withInstanceSetting(Settings.setting((String)"jmx.port", (Function)Settings.STRING, (String)null), (IntFunction)ClusterRule.intBase(9912))).withInstanceSetting(HaSettings.ha_server, (IntFunction)ClusterRule.stringWithIntBase(":", 1136))).withInstanceSetting(GraphDatabaseSettings.forced_kernel_id, (IntFunction)ClusterRule.stringWithIntBase("kernel", 0));

    public Neo4jManager beans(HighlyAvailableGraphDatabase db) {
        return new Neo4jManager((Kernel)((JmxKernelExtension)db.getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(Kernel.class));
    }

    public HighAvailability ha(HighlyAvailableGraphDatabase db) {
        return this.beans(db).getHighAvailabilityBean();
    }

    @Test
    public void canGetHaBean() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        HighAvailability ha = this.ha(cluster.getMaster());
        Assert.assertNotNull((String)"could not get ha bean", (Object)ha);
        this.assertMasterInformation(ha);
    }

    private void assertMasterInformation(HighAvailability ha) {
        Assert.assertTrue((String)"should be available", (boolean)ha.isAvailable());
        Assert.assertEquals((String)"should be master", (Object)"master", (Object)ha.getRole());
        Assert.assertEquals((String)"should be instance 1", (Object)"1", (Object)ha.getInstanceId());
    }

    @Test
    public void testLatestTxInfoIsCorrect() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        HighlyAvailableGraphDatabase db = cluster.getMaster();
        HighAvailability masterHa = this.ha(db);
        long lastCommitted = masterHa.getLastCommittedTxId();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        Assert.assertEquals((long)(lastCommitted + 1L), (long)masterHa.getLastCommittedTxId());
    }

    @Test
    public void testUpdatePullWorksAndUpdatesLastUpdateTime() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = master.beginTx();){
            master.createNode();
            tx.success();
        }
        HighAvailability slaveBean = this.ha(slave);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-DD kk:mm:ss.SSSZZZZ");
        slaveBean.update();
        long timeUpdated = format.parse(slaveBean.getLastUpdateTime()).getTime();
        Assert.assertTrue((timeUpdated > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAfterGentleMasterSwitchClusterInfoIsCorrect() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        ClusterManager.RepairKit masterShutdown = cluster.shutdown(cluster.getMaster());
        try {
            for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
                Assert.assertEquals((long)2L, (long)this.ha(db).getInstancesInCluster().length);
            }
        }
        finally {
            masterShutdown.repair();
        }
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
            HighAvailability bean = this.ha(db);
            Assert.assertEquals((long)3L, (long)bean.getInstancesInCluster().length);
            for (ClusterMemberInfo info : bean.getInstancesInCluster()) {
                Assert.assertTrue((String)"every instance should be available", (boolean)info.isAvailable());
                Assert.assertTrue((String)"every instances should have at least one role", (info.getRoles().length > 0 ? 1 : 0) != 0);
                if ("master".equals(info.getRoles()[0])) {
                    Assert.assertEquals((String)"coordinator should be master", (Object)"master", (Object)info.getHaRole());
                } else {
                    Assert.assertEquals((String)"Either master or slave, no other way", (Object)"slave", (Object)info.getRoles()[0]);
                    Assert.assertEquals((String)("instance " + info.getInstanceId() + " is cluster slave but HA master"), (Object)"slave", (Object)info.getHaRole());
                }
                for (String uri : info.getUris()) {
                    Assert.assertTrue((String)"roles should contain URIs", (uri.startsWith("ha://") || uri.startsWith("backup://") ? 1 : 0) != 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAfterHardMasterSwitchClusterInfoIsCorrect() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        ClusterManager.RepairKit masterShutdown = cluster.fail(cluster.getMaster());
        try {
            for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
                if (db.getInstanceState() == HighAvailabilityMemberState.PENDING) continue;
                Assert.assertEquals((long)3L, (long)this.ha(db).getInstancesInCluster().length);
            }
        }
        finally {
            masterShutdown.repair();
        }
        cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
            int mastersFound = 0;
            HighAvailability bean = this.ha(db);
            Assert.assertEquals((long)3L, (long)bean.getInstancesInCluster().length);
            for (ClusterMemberInfo info : bean.getInstancesInCluster()) {
                Assert.assertTrue((String)(bean.getInstanceId() + ": every instance should be available: " + info.getInstanceId()), (boolean)info.isAvailable());
                for (String role : info.getRoles()) {
                    if (!role.equals("master")) continue;
                    ++mastersFound;
                }
            }
            Assert.assertEquals((long)1L, (long)mastersFound);
        }
    }

    @Test
    public void canGetBranchedStoreBean() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        BranchedStore bs = this.beans(cluster.getMaster()).getBranchedStoreBean();
        Assert.assertNotNull((String)"could not get branched store bean", (Object)bs);
        Assert.assertEquals((String)"no branched stores for new db", (long)0L, (long)bs.getBranchedStores().length);
    }

    @Test
    public void joinedInstanceShowsUpAsSlave() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        ClusterMemberInfo[] instancesInCluster = this.ha(cluster.getMaster()).getInstancesInCluster();
        Assert.assertEquals((long)3L, (long)instancesInCluster.length);
        ClusterMemberInfo[] secondInstancesInCluster = this.ha(cluster.getAnySlave(new HighlyAvailableGraphDatabase[0])).getInstancesInCluster();
        Assert.assertEquals((long)3L, (long)secondInstancesInCluster.length);
        this.assertMasterAndSlaveInformation(instancesInCluster);
        this.assertMasterAndSlaveInformation(secondInstancesInCluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void leftInstanceDisappearsFromMemberList() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        Assert.assertEquals((long)3L, (long)this.ha(cluster.getAnySlave(new HighlyAvailableGraphDatabase[0])).getInstancesInCluster().length);
        ClusterManager.RepairKit repair = cluster.shutdown(cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]));
        try {
            cluster.await(ClusterManager.masterSeesMembers(2));
            HighAvailability haMaster = this.ha(cluster.getMaster());
            Assert.assertEquals((long)2L, (long)haMaster.getInstancesInCluster().length);
        }
        finally {
            repair.repair();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failedMemberIsStillInMemberListAlthoughFailed() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        Assert.assertEquals((long)3L, (long)this.ha(cluster.getAnySlave(new HighlyAvailableGraphDatabase[0])).getInstancesInCluster().length);
        HighlyAvailableGraphDatabase failedDb = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        ClusterManager.RepairKit dbFailure = cluster.fail(failedDb);
        try {
            this.await(this.ha(cluster.getMaster()), this.dbAlive(false));
            this.await(this.ha(cluster.getAnySlave(failedDb)), this.dbAlive(false));
        }
        finally {
            dbFailure.repair();
        }
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
            this.await(this.ha(db), this.dbAvailability(true));
            this.await(this.ha(db), this.dbAlive(true));
        }
    }

    public static URI getUriForScheme(final String scheme, Iterable<URI> uris) {
        return (URI)Iterables.first((Iterable)Iterables.filter((Predicate)new Predicate<URI>(){

            public boolean test(URI item) {
                return item.getScheme().equals(scheme);
            }
        }, uris));
    }

    private void assertMasterAndSlaveInformation(ClusterMemberInfo[] instancesInCluster) throws Exception {
        ClusterMemberInfo master = this.member(instancesInCluster, 1);
        Assert.assertEquals((long)1137L, (long)HaBeanIT.getUriForScheme("ha", Iterables.map((org.neo4j.function.Function)new org.neo4j.function.Function<String, URI>(){

            public URI apply(String from) {
                return URI.create(from);
            }
        }, Arrays.asList(master.getUris()))).getPort());
        Assert.assertEquals((Object)"master", (Object)master.getHaRole());
        ClusterMemberInfo slave = this.member(instancesInCluster, 2);
        Assert.assertEquals((long)1138L, (long)HaBeanIT.getUriForScheme("ha", Iterables.map((org.neo4j.function.Function)new org.neo4j.function.Function<String, URI>(){

            public URI apply(String from) {
                return URI.create(from);
            }
        }, Arrays.asList(slave.getUris()))).getPort());
        Assert.assertEquals((Object)"slave", (Object)slave.getHaRole());
        Assert.assertTrue((String)"Slave not available", (boolean)slave.isAvailable());
    }

    private ClusterMemberInfo member(ClusterMemberInfo[] members, int instanceId) {
        for (ClusterMemberInfo member : members) {
            if (!member.getInstanceId().equals(Integer.toString(instanceId))) continue;
            return member;
        }
        Assert.fail((String)("Couldn't find cluster member with cluster URI port " + instanceId + " among " + Arrays.toString(members)));
        return null;
    }

    private void await(HighAvailability ha, Predicate<ClusterMemberInfo> predicate) throws InterruptedException {
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(300L);
        while (System.currentTimeMillis() < end) {
            if (predicate.test((Object)this.member(ha.getInstancesInCluster(), 2))) {
                return;
            }
            Thread.sleep(500L);
        }
        Assert.fail((String)"Failed instance didn't show up as such in JMX");
    }

    private Predicate<ClusterMemberInfo> dbAvailability(final boolean available) {
        return new Predicate<ClusterMemberInfo>(){

            public boolean test(ClusterMemberInfo item) {
                return item.isAvailable() == available;
            }
        };
    }

    private Predicate<ClusterMemberInfo> dbAlive(final boolean alive) {
        return new Predicate<ClusterMemberInfo>(){

            public boolean test(ClusterMemberInfo item) {
                return item.isAlive() == alive;
            }
        };
    }
}

