/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Predicate;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class TestClusterClientPadding {
    @Rule
    public ClusterRule clusterRule = new ClusterRule(this.getClass());
    private ClusterManager.ManagedCluster cluster;

    @Before
    public void setUp() throws Throwable {
        this.cluster = ((ClusterRule)this.clusterRule.withProvider(ClusterManager.clusterWithAdditionalClients(2, 1)).withAvailabilityChecks(new Predicate[]{ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]), ClusterManager.masterSeesMembers(3), ClusterManager.allSeesAllAsJoined()})).startCluster();
    }

    @Test
    public void additionalClusterClientCanHelpBreakTiesWhenMasterIsShutDown() throws Throwable {
        HighlyAvailableGraphDatabase sittingMaster = this.cluster.getMaster();
        this.cluster.shutdown(sittingMaster);
        this.cluster.await(ClusterManager.masterAvailable(sittingMaster));
    }

    @Test
    public void additionalClusterClientCanHelpBreakTiesWhenMasterFails() throws Throwable {
        HighlyAvailableGraphDatabase sittingMaster = this.cluster.getMaster();
        this.cluster.fail(sittingMaster);
        this.cluster.await(ClusterManager.masterAvailable(sittingMaster));
    }
}

