/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.function.IntFunction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.TargetDirectory;

public class TestPullUpdates {
    private ClusterManager.ManagedCluster cluster;
    private static final int PULL_INTERVAL = 100;
    private static final int SHELL_PORT = 6370;
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    @After
    public void doAfter() throws Throwable {
        if (this.cluster != null) {
            this.cluster.stop();
        }
    }

    @Test
    public void makeSureUpdatePullerGetsGoingAfterMasterSwitch() throws Throwable {
        File root = this.testDirectory.directory(this.testName.getMethodName());
        ClusterManager clusterManager = ((ClusterManager.Builder)new ClusterManager.Builder(root).withSharedConfig(MapUtil.stringMap((String[])new String[]{HaSettings.pull_interval.name(), "100ms", ClusterSettings.heartbeat_interval.name(), "2s", ClusterSettings.heartbeat_timeout.name(), "30s"}))).build();
        clusterManager.start();
        this.cluster = clusterManager.getDefaultCluster();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        this.cluster.info("### Creating initial dataset");
        long commonNodeId = this.createNodeOnMaster();
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        this.setProperty(master, commonNodeId, 1);
        this.cluster.info("### Initial dataset created");
        this.awaitPropagation(1, commonNodeId, this.cluster, new HighlyAvailableGraphDatabase[0]);
        this.cluster.info("### Shutting down master");
        ClusterManager.RepairKit masterShutdownRK = this.cluster.shutdown(master);
        this.cluster.info("### Awaiting new master");
        this.cluster.await(ClusterManager.masterAvailable(master));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        this.cluster.info("### Doing a write to master");
        this.setProperty(this.cluster.getMaster(), commonNodeId, 2);
        this.awaitPropagation(2, commonNodeId, this.cluster, master);
        this.cluster.info("### Repairing cluster");
        masterShutdownRK.repair();
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        this.cluster.info("### Awaiting change propagation");
        this.awaitPropagation(2, commonNodeId, this.cluster, new HighlyAvailableGraphDatabase[0]);
    }

    @Test
    public void pullUpdatesShellAppPullsUpdates() throws Throwable {
        File root = this.testDirectory.directory(this.testName.getMethodName());
        ClusterManager clusterManager = ((ClusterManager.Builder)((ClusterManager.Builder)new ClusterManager.Builder(root).withProvider(ClusterManager.clusterOfSize(2)).withSharedConfig(MapUtil.stringMap((String[])new String[]{HaSettings.pull_interval.name(), "0", HaSettings.tx_push_factor.name(), "0", ShellSettings.remote_shell_enabled.name(), "true"}))).withInstanceConfig(MapUtil.genericMap((Object[])new Object[]{ShellSettings.remote_shell_port.name(), new IntFunction<String>(){

            public String apply(int oneBasedServerId) {
                return oneBasedServerId >= 1 && oneBasedServerId <= 2 ? "" + (6370 + oneBasedServerId) : null;
            }
        }}))).build();
        clusterManager.start();
        this.cluster = clusterManager.getDefaultCluster();
        long commonNodeId = this.createNodeOnMaster();
        this.setProperty(this.cluster.getMaster(), commonNodeId, 1);
        this.callPullUpdatesViaShell(2);
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = slave.beginTx();){
            Assert.assertEquals((Object)1, (Object)slave.getNodeById(commonNodeId).getProperty("i"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldPullUpdatesOnStartupNoMatterWhat() throws Exception {
        GraphDatabaseService slave = null;
        GraphDatabaseService master = null;
        try {
            long nodeId;
            File testRootDir = this.testDirectory.directory(this.testName.getMethodName());
            File masterDir = new File(testRootDir, "master");
            master = new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(masterDir.getAbsolutePath()).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.initial_hosts, "localhost:5001").newGraphDatabase();
            File slaveDir = new File(testRootDir, "slave");
            slave = new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(slaveDir.getAbsolutePath()).setConfig(ClusterSettings.server_id, "2").setConfig(ClusterSettings.initial_hosts, "localhost:5001").newGraphDatabase();
            final CountDownLatch slaveLeftLatch = new CountDownLatch(1);
            final ClusterClient masterClusterClient = (ClusterClient)((HighlyAvailableGraphDatabase)master).getDependencyResolver().resolveDependency(ClusterClient.class);
            masterClusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){

                public void leftCluster(InstanceId instanceId, URI member) {
                    slaveLeftLatch.countDown();
                    masterClusterClient.removeClusterListener((ClusterListener)this);
                }
            });
            ((LogService)((GraphDatabaseAPI)master).getDependencyResolver().resolveDependency(LogService.class)).getInternalLog(this.getClass()).info("SHUTTING DOWN SLAVE");
            slave.shutdown();
            Assert.assertTrue((String)"Timeout waiting for slave to leave", (boolean)slaveLeftLatch.await(60L, TimeUnit.SECONDS));
            try (Transaction tx = master.beginTx();){
                Node node = master.createNode();
                node.setProperty("from", (Object)"master");
                nodeId = node.getId();
                tx.success();
            }
            slave = new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(slaveDir.getAbsolutePath()).setConfig(ClusterSettings.server_id, "2").setConfig(ClusterSettings.initial_hosts, "localhost:5001").setConfig(HaSettings.pull_interval, "0").newGraphDatabase();
            slave.beginTx().close();
            tx = slave.beginTx();
            var11_9 = null;
            try {
                Assert.assertEquals((Object)"master", (Object)slave.getNodeById(nodeId).getProperty("from"));
                tx.success();
            }
            catch (Throwable throwable) {
                var11_9 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var11_9 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            var11_9.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            if (slave != null) {
                slave.shutdown();
            }
            if (master != null) {
                master.shutdown();
            }
        }
    }

    private long createNodeOnMaster() {
        try (Transaction tx = this.cluster.getMaster().beginTx();){
            long id = this.cluster.getMaster().createNode().getId();
            tx.success();
            long l = id;
            return l;
        }
    }

    private void callPullUpdatesViaShell(int i) throws ShellException {
        ShellClient client = ShellLobby.newClient((int)(6370 + i));
        client.evaluate("pullupdates");
    }

    private void powerNap() throws InterruptedException {
        Thread.sleep(50L);
    }

    private void awaitPropagation(int expectedPropertyValue, long nodeId, ClusterManager.ManagedCluster cluster, HighlyAvailableGraphDatabase ... excepts) throws Exception {
        long endTime = System.currentTimeMillis() + 2000L;
        boolean ok = false;
        while (!ok && System.currentTimeMillis() < endTime) {
            ok = true;
            block12: for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
                for (HighlyAvailableGraphDatabase except : excepts) {
                    if (db == except) continue block12;
                }
                try {
                    Transaction tx = db.beginTx();
                    Throwable throwable = null;
                    try {
                        Number value = (Number)db.getNodeById(nodeId).getProperty("i", null);
                        if (value != null && value.intValue() == expectedPropertyValue) continue;
                        ok = false;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                catch (NotFoundException e) {
                    ok = false;
                }
            }
            if (ok) continue;
            this.powerNap();
        }
        Assert.assertTrue((String)"Change wasn't propagated by pulling updates", (boolean)ok);
    }

    private void setProperty(HighlyAvailableGraphDatabase db, long nodeId, int i) throws Exception {
        try (Transaction tx = db.beginTx();){
            db.getNodeById(nodeId).setProperty("i", (Object)i);
            tx.success();
        }
    }
}

