/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.upgrade;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.neo4j.io.fs.FileUtils;

public class Utils {
    private Utils() {
    }

    public static String assembleClassPathFromPackage(File directory) {
        ArrayList<File> jarFiles = new ArrayList<File>();
        FileFilter jarFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".jar");
            }
        };
        Utils.gatherFiles(jarFiles, directory, jarFilter);
        StringBuilder classpath = new StringBuilder();
        for (File file : jarFiles) {
            classpath.append(classpath.length() > 0 ? File.pathSeparator : "").append(file.getAbsolutePath());
        }
        return classpath.toString();
    }

    private static void gatherFiles(List<File> jarFiles, File directory, FileFilter filter) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                Utils.gatherFiles(jarFiles, file, filter);
                continue;
            }
            if (!filter.accept(file)) continue;
            jarFiles.add(file);
        }
    }

    public static File downloadAndUnpack(String url, File targetDirectory, String downloadedFileName) throws IOException {
        File unpacked;
        URL website = new URL(url);
        File downloaded = new File(targetDirectory, downloadedFileName + ".zip");
        if (!downloaded.exists()) {
            File tmpDownload = new File(downloaded.getAbsolutePath() + ".tmp");
            FileUtils.deleteFile((File)tmpDownload);
            org.apache.commons.io.FileUtils.copyURLToFile((URL)website, (File)tmpDownload, (int)5000, (int)10000);
            FileUtils.moveFile((File)tmpDownload, (File)downloaded);
        }
        if (!(unpacked = new File(targetDirectory, downloadedFileName)).exists()) {
            File tmpUnpack = new File(unpacked.getAbsolutePath() + "-tmp");
            FileUtils.deleteRecursively((File)tmpUnpack);
            tmpUnpack.mkdirs();
            Utils.unzip(downloaded, tmpUnpack);
            FileUtils.moveFile((File)tmpUnpack, (File)unpacked);
        }
        return unpacked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> unzip(File zipFile, File targetDir) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        try (ZipFile zip = new ZipFile(zipFile);){
            zip = new ZipFile(zipFile);
            for (ZipEntry zipEntry : Collections.list(zip.entries())) {
                File target = new File(targetDir, zipEntry.getName());
                target.getParentFile().mkdirs();
                if (zipEntry.isDirectory()) continue;
                InputStream input = zip.getInputStream(zipEntry);
                try {
                    Utils.copyInputStreamToFile(input, target);
                    files.add(target);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                }
            }
            ArrayList<File> arrayList = files;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInputStreamToFile(InputStream stream, File target) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(target);
            IOUtils.copy((InputStream)stream, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static Process execJava(String classPath, String mainClass, String ... args) throws Exception {
        ArrayList<String> allArgs = new ArrayList<String>(Arrays.asList("java", "-cp", classPath, mainClass));
        allArgs.addAll(Arrays.asList(args));
        return Runtime.getRuntime().exec(allArgs.toArray(new String[0]));
    }
}

