/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransientDatabaseFailureException;
import org.neo4j.kernel.ha.DelegateInvocationHandler;

public class DelegateInvocationHandlerTest {
    @Test
    public void shouldNotBeAbleToUseValueBeforeHardened() throws Exception {
        DelegateInvocationHandler<Value> handler = DelegateInvocationHandlerTest.newDelegateInvocationHandler();
        Value value = (Value)handler.cement();
        try {
            value.get();
            Assert.fail((String)"Should fail");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransientDatabaseFailureException.class));
        }
    }

    @Test
    public void throwsWhenDelegateIsNotSet() {
        DelegateInvocationHandler<Value> handler = DelegateInvocationHandlerTest.newDelegateInvocationHandler();
        try {
            handler.invoke(new Object(), Value.class.getDeclaredMethod("get", new Class[0]), new Object[0]);
            Assert.fail((String)"Exception expected");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)Matchers.instanceOf(TransactionFailureException.class));
        }
    }

    @Test
    public void shouldBeAbleToUseCementedValueOnceDelegateSet() throws Exception {
        DelegateInvocationHandler<Value> handler = DelegateInvocationHandlerTest.newDelegateInvocationHandler();
        Value cementedValue = (Value)handler.cement();
        handler.setDelegate((Object)this.value(10));
        Assert.assertEquals((long)10L, (long)cementedValue.get());
    }

    @Test
    public void shouldBeAbleToUseCementedValueOnceHardened() throws Exception {
        DelegateInvocationHandler<Value> handler = DelegateInvocationHandlerTest.newDelegateInvocationHandler();
        Value cementedValue = (Value)handler.cement();
        handler.setDelegate((Object)this.value(10));
        Assert.assertEquals((long)10L, (long)cementedValue.get());
    }

    @Test
    public void setDelegateShouldBeAbleToOverridePreviousHarden() throws Exception {
        DelegateInvocationHandler<Value> handler = DelegateInvocationHandlerTest.newDelegateInvocationHandler();
        handler.setDelegate((Object)this.value(10));
        Value cementedValue = (Value)handler.cement();
        handler.harden();
        handler.setDelegate((Object)this.value(20));
        Assert.assertEquals((long)20L, (long)cementedValue.get());
    }

    @Test
    public void setDelegateDoesNotAcceptNullArgument() {
        DelegateInvocationHandler<Value> handler = DelegateInvocationHandlerTest.newDelegateInvocationHandler();
        try {
            handler.setDelegate(null);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NullPointerException.class));
        }
    }

    private Value value(final int i) {
        return new Value(){

            @Override
            public int get() {
                return i;
            }
        };
    }

    private static DelegateInvocationHandler<Value> newDelegateInvocationHandler() {
        return new DelegateInvocationHandler(Value.class);
    }

    private static interface Value {
        public int get();
    }
}

