/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.neo4j.com.ComException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.graphdb.TransientDatabaseFailureException;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.DistributedLockFailureException;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.LockStatus;
import org.neo4j.kernel.ha.lock.SlaveLocksClient;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.community.CommunityLockManger;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class SlaveLocksClientTest {
    private Master master;
    private Locks.Client local;
    private SlaveLocksClient client;
    private AvailabilityGuard availabilityGuard;

    @Before
    public void setUp() throws Exception {
        this.master = (Master)Mockito.mock(Master.class);
        RequestContextFactory requestContextFactory = (RequestContextFactory)Mockito.mock(RequestContextFactory.class);
        this.availabilityGuard = new AvailabilityGuard((Clock)new FakeClock(), (Log)NullLog.getInstance());
        CommunityLockManger lockManager = new CommunityLockManger();
        this.local = (Locks.Client)Mockito.spy((Object)lockManager.newClient());
        LockResult lockResultOk = new LockResult(LockStatus.OK_LOCKED);
        TransactionStreamResponse responseOk = new TransactionStreamResponse((Object)lockResultOk, null, TransactionStream.EMPTY, ResourceReleaser.NO_OP);
        this.whenMasterAcquireShared().thenReturn((Object)responseOk);
        this.whenMasterAcquireExclusive().thenReturn((Object)responseOk);
        this.client = new SlaveLocksClient(this.master, this.local, (Locks)lockManager, requestContextFactory, this.availabilityGuard);
    }

    private OngoingStubbing<Response<LockResult>> whenMasterAcquireShared() {
        return Mockito.when((Object)this.master.acquireSharedLock((RequestContext)Matchers.any(RequestContext.class), (Locks.ResourceType)Matchers.any(Locks.ResourceType.class), (long[])Matchers.anyVararg()));
    }

    private OngoingStubbing<Response<LockResult>> whenMasterAcquireExclusive() {
        return Mockito.when((Object)this.master.acquireExclusiveLock((RequestContext)Matchers.any(RequestContext.class), (Locks.ResourceType)Matchers.any(Locks.ResourceType.class), (long[])Matchers.anyVararg()));
    }

    @After
    public void tearDown() {
        this.local.close();
    }

    @Test
    public void shouldNotTakeSharedLockOnMasterIfWeAreAlreadyHoldingSaidLock() {
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Master)Mockito.verify((Object)this.master)).acquireSharedLock(null, (Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void shouldNotTakeExclusiveLockOnMasterIfWeAreAlreadyHoldingSaidLock() {
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Master)Mockito.verify((Object)this.master)).acquireExclusiveLock(null, (Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void shouldAllowAcquiringReleasingAndReacquiringExclusive() throws Exception {
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldAllowAcquiringReleasingAndReacquiringShared() throws Exception {
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).trySharedLock((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).releaseShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldNotTalkToLocalLocksOnReentrancyExclusive() throws Exception {
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)1))).tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)0))).releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldNotTalkToLocalLocksOnReentrancyShared() throws Exception {
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)1))).trySharedLock((Locks.ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)0))).releaseShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldReturnNoLockSessionIfNotInitialized() throws Exception {
        int lockSessionId = this.client.getLockSessionId();
        MatcherAssert.assertThat((Object)lockSessionId, (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void shouldReturnDelegateIdIfInitialized() throws Exception {
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        int lockSessionId = this.client.getLockSessionId();
        MatcherAssert.assertThat((Object)lockSessionId, (Matcher)CoreMatchers.equalTo((Object)this.local.getLockSessionId()));
    }

    @Test(expected=DistributedLockFailureException.class)
    public void mustThrowIfStartingNewLockSessionOnMasterThrowsComException() throws Exception {
        Mockito.when((Object)this.master.newLockSession((RequestContext)Matchers.any(RequestContext.class))).thenThrow(new Throwable[]{new ComException()});
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=DistributedLockFailureException.class)
    public void mustThrowIfStartingNewLockSessionOnMasterThrowsTransactionFailureException() throws Exception {
        Mockito.when((Object)this.master.newLockSession((RequestContext)Matchers.any(RequestContext.class))).thenThrow(new Throwable[]{new TransactionFailureException((Status)Status.General.DatabaseUnavailable, "Not now", new Object[0])});
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=DistributedLockFailureException.class)
    public void acquireSharedMustThrowIfMasterThrows() throws Exception {
        this.whenMasterAcquireShared().thenThrow(new Throwable[]{new ComException()});
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=DistributedLockFailureException.class)
    public void acquireExclusiveMustThrowIfMasterThrows() throws Exception {
        this.whenMasterAcquireExclusive().thenThrow(new Throwable[]{new ComException()});
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void tryExclusiveMustBeUnsupported() throws Exception {
        this.client.tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void trySharedMustBeUnsupported() throws Exception {
        this.client.trySharedLock((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=DistributedLockFailureException.class)
    public void releaseAllMustThrowIfMasterThrows() throws Exception {
        Mockito.when((Object)this.master.endLockSession((RequestContext)Matchers.any(RequestContext.class), Matchers.anyBoolean())).thenThrow(new Throwable[]{new ComException()});
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseAll();
    }

    @Test(expected=DistributedLockFailureException.class)
    public void closeMustThrowIfMasterThrows() throws Exception {
        Mockito.when((Object)this.master.endLockSession((RequestContext)Matchers.any(RequestContext.class), Matchers.anyBoolean())).thenThrow(new Throwable[]{new ComException()});
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
        this.client.close();
    }

    @Test
    public void mustCloseLocalClientEvenIfMasterThrows() throws Exception {
        Mockito.when((Object)this.master.endLockSession((RequestContext)Matchers.any(RequestContext.class), Matchers.anyBoolean())).thenThrow(new Throwable[]{new ComException()});
        try {
            this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
            this.client.close();
            Assert.fail((String)"Expected client.close to throw");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Locks.Client)Mockito.verify((Object)this.local)).close();
    }

    @Test(expected=TransientDatabaseFailureException.class)
    public void mustThrowTransientTransactionFailureIfDatabaseUnavailable() throws Exception {
        this.availabilityGuard.shutdown();
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldFailWithTransientErrorOnDbUnavailable() throws Exception {
        this.availabilityGuard.shutdown();
        try {
            this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, 0L);
            Assert.fail((String)"Should fail");
        }
        catch (TransientFailureException transientFailureException) {
            // empty catch block
        }
    }
}

