/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.index;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class AutoIndexConfigIT {
    @ClassRule
    public static ClusterRule clusterRule = new ClusterRule(AutoIndexConfigIT.class);

    @Test
    public void programmaticConfigShouldSurviveMasterSwitches() throws Throwable {
        String propertyToIndex = "programmatic-property";
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        AutoIndexer originalAutoIndex = slave.index().getNodeAutoIndexer();
        originalAutoIndex.setEnabled(true);
        originalAutoIndex.startAutoIndexingProperty(propertyToIndex);
        cluster.shutdown(cluster.getMaster());
        cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        AutoIndexer newAutoIndex = slave.index().getNodeAutoIndexer();
        Assert.assertThat((Object)newAutoIndex.isEnabled(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newAutoIndex.getAutoIndexedProperties(), (Matcher)CoreMatchers.hasItem((Object)propertyToIndex));
    }
}

