/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.factory;

import java.lang.reflect.Proxy;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.CommitProcessSwitcher;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.ReadOnlyTransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.state.NeoStoreInjectedTransactionValidator;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

class HighlyAvailableCommitProcessFactory
implements CommitProcessFactory {
    private final LifeSupport modeSwitchersLife;
    private final Master master;
    private final TransactionPropagator transactionPropagator;
    private final RequestContextFactory requestContextFactory;
    private final HighAvailabilityModeSwitcher highAvailabilityModeSwitcher;
    private final DelegateInvocationHandler<TransactionCommitProcess> commitProcessDelegate = new DelegateInvocationHandler<TransactionCommitProcess>(TransactionCommitProcess.class);

    HighlyAvailableCommitProcessFactory(LifeSupport modeSwitchersLife, Master master, TransactionPropagator transactionPropagator, RequestContextFactory requestContextFactory, HighAvailabilityModeSwitcher highAvailabilityModeSwitcher) {
        this.modeSwitchersLife = modeSwitchersLife;
        this.master = master;
        this.transactionPropagator = transactionPropagator;
        this.requestContextFactory = requestContextFactory;
        this.highAvailabilityModeSwitcher = highAvailabilityModeSwitcher;
    }

    public TransactionCommitProcess create(TransactionAppender appender, TransactionRepresentationStoreApplier storeApplier, NeoStoreInjectedTransactionValidator txValidator, IndexUpdatesValidator indexUpdatesValidator, Config config) {
        if (((Boolean)config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTransactionCommitProcess();
        }
        this.removeOldCommitSwitcher();
        TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess(appender, storeApplier, indexUpdatesValidator);
        CommitProcessSwitcher commitProcessSwitcher = new CommitProcessSwitcher(this.transactionPropagator, this.master, this.commitProcessDelegate, this.requestContextFactory, this.highAvailabilityModeSwitcher, txValidator, (TransactionCommitProcess)commitProcess);
        this.modeSwitchersLife.add((Lifecycle)commitProcessSwitcher);
        return (TransactionCommitProcess)Proxy.newProxyInstance(TransactionCommitProcess.class.getClassLoader(), new Class[]{TransactionCommitProcess.class}, this.commitProcessDelegate);
    }

    private void removeOldCommitSwitcher() {
        for (Lifecycle instance : this.modeSwitchersLife.getLifecycleInstances()) {
            if (!(instance instanceof CommitProcessSwitcher)) continue;
            this.modeSwitchersLife.remove((Object)instance);
        }
    }
}

