/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.ha.ClusterRule;

@Ignore(value="A good idea but the test is too high level, is fragile and takes too long.")
public class PullStormIT {
    @ClassRule
    public static ClusterRule clusterRule = ((ClusterRule)new ClusterRule(PullStormIT.class).withSharedSetting(HaSettings.pull_interval, "0")).withSharedSetting(HaSettings.tx_push_factor, "1");
    @ClassRule
    public static LoggerRule logger = new LoggerRule(Level.OFF);

    @Test
    public void testPullStorm() throws Throwable {
        int i;
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        final HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            for (i = 0; i < 1000; ++i) {
                master.createNode().setProperty("foo", (Object)"bar");
            }
            tx.success();
        }
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        ClusterManager.RepairKit repairKit = cluster.fail(slave);
        for (i = 0; i < 1000; ++i) {
            try (Transaction tx = master.beginTx();){
                for (int j = 0; j < 1000; ++j) {
                    master.createNode().setProperty("foo", (Object)"bar");
                    master.createNode().setProperty("foo", (Object)"bar");
                }
                tx.success();
                continue;
            }
        }
        repairKit.repair();
        cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        ExecutorService executor = Executors.newFixedThreadPool(20);
        for (int i2 = 0; i2 < 20; ++i2) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try (Transaction tx = master.beginTx();){
                        master.createNode().setProperty("foo", (Object)"bar");
                        tx.success();
                    }
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.MINUTES);
        long masterLastCommittedTxId = this.lastCommittedTxId(master);
        for (HighlyAvailableGraphDatabase member : cluster.getAllMembers()) {
            Assert.assertEquals((long)masterLastCommittedTxId, (long)this.lastCommittedTxId(member));
        }
    }

    private long lastCommittedTxId(HighlyAvailableGraphDatabase highlyAvailableGraphDatabase) {
        return ((TransactionIdStore)highlyAvailableGraphDatabase.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
    }
}

