/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.slave;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.com.ComException;
import org.neo4j.com.IllegalProtocolVersionException;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.kernel.ha.MasterClient210;
import org.neo4j.kernel.ha.MasterClient214;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class MasterClientResolverTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldResolveMasterClientFactory() throws Exception {
        MasterClientResolver resolver = new MasterClientResolver((LogProvider)NullLogProvider.getInstance(), ResponseUnpacker.NO_OP_RESPONSE_UNPACKER, (InvalidEpochExceptionHandler)Mockito.mock(InvalidEpochExceptionHandler.class), 1, 1, 1, 1024);
        LifeSupport life = new LifeSupport();
        try {
            life.start();
            MasterClient masterClient1 = resolver.instantiate("cluster://localhost", 44, null, new Monitors(), StoreId.DEFAULT, life);
            Assert.assertThat((Object)masterClient1, (Matcher)Matchers.instanceOf(MasterClient214.class));
        }
        finally {
            life.shutdown();
        }
        IllegalProtocolVersionException illegalProtocolVersionException = new IllegalProtocolVersionException(MasterClient210.PROTOCOL_VERSION.getApplicationProtocol(), MasterClient214.PROTOCOL_VERSION.getApplicationProtocol(), "Protocol is too modern");
        resolver.handle((ComException)illegalProtocolVersionException);
        life = new LifeSupport();
        try {
            life.start();
            MasterClient masterClient2 = resolver.instantiate("cluster://localhost", 55, null, new Monitors(), StoreId.DEFAULT, life);
            Assert.assertThat((Object)masterClient2, (Matcher)Matchers.instanceOf(MasterClient210.class));
        }
        finally {
            life.shutdown();
        }
    }
}

