/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.SlaveLocksClient;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class SlaveLockManager
extends LifecycleAdapter
implements Locks {
    private final RequestContextFactory requestContextFactory;
    private final Locks local;
    private final Master master;
    private final AvailabilityGuard availabilityGuard;

    public SlaveLockManager(Locks localLocks, RequestContextFactory requestContextFactory, Master master, AvailabilityGuard availabilityGuard) {
        this.requestContextFactory = requestContextFactory;
        this.availabilityGuard = availabilityGuard;
        this.local = localLocks;
        this.master = master;
    }

    public Locks.Client newClient() {
        Locks.Client client = this.local.newClient();
        return new SlaveLocksClient(this.master, client, this.local, this.requestContextFactory, this.availabilityGuard);
    }

    public void accept(Locks.Visitor visitor) {
        this.local.accept(visitor);
    }

    public void shutdown() throws Throwable {
        this.local.shutdown();
    }
}

