/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.id;

import org.neo4j.helpers.Clock;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;

public class HaIdReuseEligibility
implements IdReuseEligibility {
    private final ClusterMembers members;
    private final Clock clock;
    private final long idReuseSafeZone;

    public HaIdReuseEligibility(ClusterMembers members, Clock clock, long idReuseSafeZone) {
        this.members = members;
        this.clock = clock;
        this.idReuseSafeZone = idReuseSafeZone;
    }

    public boolean isEligible(KernelTransactionsSnapshot snapshot) {
        switch (this.members.getCurrentMemberRole()) {
            case "slave": {
                return true;
            }
            case "master": {
                return this.clock.currentTimeMillis() - snapshot.snapshotTime() >= this.idReuseSafeZone;
            }
        }
        return false;
    }
}

