/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionNotPresentOnMasterException;
import org.neo4j.com.TransactionObligationResponse;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.cluster.ConversationSPI;
import org.neo4j.kernel.ha.cluster.DefaultConversationSPI;
import org.neo4j.kernel.ha.com.master.Conversation;
import org.neo4j.kernel.ha.com.master.ConversationManager;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.impl.enterprise.lock.forseti.ForsetiLockManager;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.impl.util.collection.ConcurrentAccessException;
import org.neo4j.kernel.impl.util.collection.TimedRepository;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;

public class MasterImplConversationStopFuzzIT {
    private static final int numberOfWorkers = 10;
    private static final int numberOfOperations = 1000;
    private static final int numberOfResources = 100;
    public static final StoreId StoreId = new StoreId();
    private final LifeSupport life = new LifeSupport();
    private final ExecutorService executor = Executors.newFixedThreadPool(11);
    private final JobScheduler scheduler = (JobScheduler)this.life.add((Lifecycle)new Neo4jJobScheduler());
    private final Config config = new Config(MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "0", HaSettings.lock_read_timeout.name(), "1"}));
    private final Locks locks = new ForsetiLockManager(new Locks.ResourceType[]{ResourceTypes.NODE, ResourceTypes.SCHEMA});
    private static MasterExecutionStatistic executionStatistic = new MasterExecutionStatistic();

    @Test(timeout=50000L)
    public void shouldHandleRandomizedLoad() throws Throwable {
        DefaultConversationSPI conversationSPI = new DefaultConversationSPI(this.locks, this.scheduler);
        ExposedConversationManager conversationManager = new ExposedConversationManager((ConversationSPI)conversationSPI, this.config, 100, 0);
        ConversationTestMasterSPI conversationTestMasterSPI = new ConversationTestMasterSPI();
        MasterImpl master = new MasterImpl((MasterImpl.SPI)conversationTestMasterSPI, (ConversationManager)conversationManager, (MasterImpl.Monitor)new Monitors().newMonitor(MasterImpl.Monitor.class, new String[0]), this.config);
        this.life.add((Lifecycle)conversationManager);
        this.life.start();
        ConversationKiller conversationKiller = new ConversationKiller(conversationManager);
        this.executor.submit(conversationKiller);
        List<Callable<Void>> slaveWorkers = this.workers(master, 10);
        List<Future<Void>> workers = this.executor.invokeAll(slaveWorkers);
        for (Future<Void> future : workers) {
            future.get();
        }
        conversationKiller.stop();
        Assert.assertTrue((boolean)executionStatistic.isSuccessfulExecution());
    }

    @After
    public void cleanup() throws InterruptedException {
        this.life.shutdown();
        this.executor.shutdownNow();
    }

    private List<Callable<Void>> workers(MasterImpl master, int numWorkers) {
        LinkedList<Callable<Void>> workers = new LinkedList<Callable<Void>>();
        for (int i = 0; i < numWorkers; ++i) {
            workers.add(new SlaveEmulatorWorker(master, i));
        }
        return workers;
    }

    private static class MasterExecutionStatistic {
        private final AtomicLong alreadyInUseErrors = new AtomicLong();
        private final AtomicLong transactionNotPresentErrors = new AtomicLong();
        private final AtomicLong committedOperations = new AtomicLong();

        private MasterExecutionStatistic() {
        }

        public void reportAlreadyInUseError() {
            this.alreadyInUseErrors.incrementAndGet();
        }

        public void reportTransactionNotPresentError() {
            this.transactionNotPresentErrors.incrementAndGet();
        }

        public void reportCommittedOperation() {
            this.committedOperations.incrementAndGet();
        }

        public AtomicLong getAlreadyInUseErrors() {
            return this.alreadyInUseErrors;
        }

        public AtomicLong getTransactionNotPresentErrors() {
            return this.transactionNotPresentErrors;
        }

        public AtomicLong getCommittedOperations() {
            return this.committedOperations;
        }

        public boolean isSuccessfulExecution() {
            return this.committedOperations.get() > (this.alreadyInUseErrors.get() + this.transactionNotPresentErrors.get()) * 10L;
        }
    }

    private class ExposedConversationManager
    extends ConversationManager {
        private TimedRepository<RequestContext, Conversation> conversationStore;

        public ExposedConversationManager(ConversationSPI spi, Config config, int activityCheckInterval, int lockTimeoutAddition) {
            super(spi, config, activityCheckInterval, lockTimeoutAddition);
        }

        protected TimedRepository<RequestContext, Conversation> createConversationStore() {
            this.conversationStore = new TimedRepository(this.getConversationFactory(), this.getConversationReaper(), 1L, Clock.SYSTEM_CLOCK);
            return this.conversationStore;
        }
    }

    private static class ConversationKiller
    implements Runnable {
        private volatile boolean running = true;
        private final ConversationManager conversationManager;

        public ConversationKiller(ConversationManager conversationManager) {
            this.conversationManager = conversationManager;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                while (this.running) {
                    Iterator conversationIterator = this.conversationManager.getActiveContexts().iterator();
                    if (conversationIterator.hasNext()) {
                        RequestContext next = (RequestContext)conversationIterator.next();
                        this.conversationManager.end(next);
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                        return;
                    }
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Conversation killer failed.", e);
            }
        }

        public void stop() {
            this.running = false;
        }
    }

    static class ConversationTestMasterSPI
    implements MasterImpl.SPI {
        ConversationTestMasterSPI() {
        }

        public boolean isAccessible() {
            return true;
        }

        public StoreId storeId() {
            return StoreId;
        }

        public long applyPreparedTransaction(TransactionRepresentation preparedTransaction) throws IOException, TransactionFailureException {
            this.sleep();
            return 0L;
        }

        private void sleep() {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public long getTransactionChecksum(long txId) throws IOException {
            return 0L;
        }

        public <T> Response<T> packEmptyResponse(T response) {
            return new TransactionObligationResponse(response, StoreId, 1L, ResourceReleaser.NO_OP);
        }

        public <T> Response<T> packTransactionObligationResponse(RequestContext context, T response) {
            return this.packEmptyResponse(response);
        }

        public IdAllocation allocateIds(IdType idType) {
            throw new UnsupportedOperationException();
        }

        public Integer createRelationshipType(String name) {
            throw new UnsupportedOperationException();
        }

        public RequestContext flushStoresAndStreamStoreFiles(StoreWriter writer) {
            throw new UnsupportedOperationException();
        }

        public <T> Response<T> packTransactionStreamResponse(RequestContext context, T response) {
            throw new UnsupportedOperationException();
        }

        public int getOrCreateLabel(String name) {
            throw new UnsupportedOperationException();
        }

        public int getOrCreateProperty(String name) {
            throw new UnsupportedOperationException();
        }
    }

    static class SlaveEmulatorWorker
    implements Callable<Void> {
        private final Random random;
        private final MasterImpl master;
        private final int machineId;
        private State state = State.UNINITIALIZED;
        private final long lastTx = 0L;
        private long epoch;
        private RequestContext requestContext;

        private static boolean lowProbabilityEvent(SlaveEmulatorWorker worker) {
            return worker.random.nextInt(100) <= 1;
        }

        private static long randomResource(SlaveEmulatorWorker worker) {
            return worker.random.nextInt(100);
        }

        public SlaveEmulatorWorker(MasterImpl master, int clientNumber) {
            this.machineId = clientNumber;
            this.random = new Random(this.machineId);
            this.master = master;
        }

        @Override
        public Void call() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                this.state = this.state.next(this);
            }
            return null;
        }

        private RequestContext newRequestContext() {
            this.requestContext = new RequestContext(this.epoch, this.machineId, this.newLockSessionId(), 0L, (long)this.random.nextInt());
            return this.requestContext;
        }

        private int newLockSessionId() {
            return this.random.nextInt();
        }

        private static void endLockSession(SlaveEmulatorWorker worker) {
            boolean successfulSession = worker.random.nextBoolean();
            worker.master.endLockSession(worker.requestContext, successfulSession);
        }

        static enum State {
            UNINITIALIZED{

                @Override
                State next(SlaveEmulatorWorker worker) {
                    HandshakeResult handshake = (HandshakeResult)worker.master.handshake(0L, StoreId).response();
                    worker.epoch = handshake.epoch();
                    return IDLE;
                }
            }
            ,
            IDLE{

                @Override
                State next(SlaveEmulatorWorker worker) throws Exception {
                    if (SlaveEmulatorWorker.lowProbabilityEvent(worker)) {
                        return UNINITIALIZED;
                    }
                    if (SlaveEmulatorWorker.lowProbabilityEvent(worker)) {
                        return this.commit(worker, new RequestContext(worker.epoch, worker.machineId, -1, 0L, 0L));
                    }
                    try {
                        worker.master.newLockSession(worker.newRequestContext());
                        return IN_SESSION;
                    }
                    catch (TransactionFailureException e) {
                        if (e.getCause() instanceof ConcurrentAccessException) {
                            executionStatistic.reportAlreadyInUseError();
                            return IDLE;
                        }
                        throw e;
                    }
                }
            }
            ,
            IN_SESSION{

                @Override
                State next(SlaveEmulatorWorker worker) throws Exception {
                    if (SlaveEmulatorWorker.lowProbabilityEvent(worker)) {
                        return UNINITIALIZED;
                    }
                    int i = worker.random.nextInt(10);
                    if (i >= 5) {
                        return this.commit(worker, worker.requestContext);
                    }
                    if (i >= 4) {
                        worker.master.acquireExclusiveLock(worker.requestContext, (Locks.ResourceType)ResourceTypes.NODE, new long[]{SlaveEmulatorWorker.randomResource(worker)});
                        return IN_SESSION;
                    }
                    if (i >= 1) {
                        worker.master.acquireSharedLock(worker.requestContext, (Locks.ResourceType)ResourceTypes.NODE, new long[]{SlaveEmulatorWorker.randomResource(worker)});
                        return IN_SESSION;
                    }
                    SlaveEmulatorWorker.endLockSession(worker);
                    return IDLE;
                }
            }
            ,
            CLOSING_SESSION{

                @Override
                State next(SlaveEmulatorWorker worker) throws Exception {
                    if (SlaveEmulatorWorker.lowProbabilityEvent(worker)) {
                        return UNINITIALIZED;
                    }
                    SlaveEmulatorWorker.endLockSession(worker);
                    return IDLE;
                }
            };


            abstract State next(SlaveEmulatorWorker var1) throws Exception;

            protected State commit(SlaveEmulatorWorker worker, RequestContext requestContext) throws IOException, TransactionFailureException {
                try {
                    worker.master.commit(requestContext, (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class));
                    executionStatistic.reportCommittedOperation();
                    return CLOSING_SESSION;
                }
                catch (TransactionNotPresentOnMasterException e) {
                    executionStatistic.reportTransactionNotPresentError();
                    return IDLE;
                }
            }
        }
    }
}

