/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.cluster.ModeSwitcher;
import org.neo4j.kernel.ha.cluster.ModeSwitcherNotifier;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public abstract class AbstractModeSwitcher<T>
implements ModeSwitcher,
Lifecycle {
    private final DelegateInvocationHandler<T> delegate;
    private final ModeSwitcherNotifier notifier;
    private T current = null;
    private LifeSupport life = new LifeSupport();

    protected AbstractModeSwitcher(ModeSwitcherNotifier notifier, DelegateInvocationHandler<T> delegate) {
        this.notifier = notifier;
        this.delegate = delegate;
    }

    public void init() throws Throwable {
        this.life.init();
    }

    public void start() throws Throwable {
        this.life.start();
        this.notifier.addModeSwitcher(this);
    }

    public void stop() throws Throwable {
        this.life.stop();
        this.notifier.removeModeSwitcher(this);
    }

    public void shutdown() throws Throwable {
        this.life.shutdown();
    }

    @Override
    public void switchToMaster() {
        this.shutdownCurrent();
        this.current = this.getMasterImpl(this.life);
        this.delegate.setDelegate(this.current);
        this.life.start();
    }

    @Override
    public void switchToSlave() {
        this.shutdownCurrent();
        this.current = this.getSlaveImpl(this.life);
        this.delegate.setDelegate(this.current);
        this.life.start();
    }

    @Override
    public void switchToPending() {
        this.shutdownCurrent();
    }

    private void shutdownCurrent() {
        if (this.current != null) {
            this.life.shutdown();
            this.life = new LifeSupport();
        }
    }

    protected abstract T getSlaveImpl(LifeSupport var1);

    protected abstract T getMasterImpl(LifeSupport var1);
}

