/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.function.IntFunction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.exceptions.ReadOnlyDbException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class ReadOnlySlaveTest {
    @Rule
    public final ClusterRule clusterRule = ((ClusterRule)new ClusterRule(this.getClass()).withSharedSetting(HaSettings.tx_push_factor, "2")).withInstanceSetting(GraphDatabaseSettings.read_only, (IntFunction)new IntFunction<String>(){

        public String apply(int oneBasedServerId) {
            return oneBasedServerId == 2 ? "true" : null;
        }
    });

    @Test
    public void givenClusterWithReadOnlySlaveWhenWriteTxOnSlaveThenCommitFails() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase readOnlySlave = cluster.getMemberByServerId(new InstanceId(2));
        try (Transaction tx = readOnlySlave.beginTx();){
            readOnlySlave.createNode();
            tx.success();
        }
        catch (TransactionFailureException ex) {
            Assert.assertThat((Object)ex.getCause(), (Matcher)CoreMatchers.instanceOf(ReadOnlyDbException.class));
        }
    }

    @Test
    public void givenClusterWithReadOnlySlaveWhenChangePropertyOnSlaveThenThrowException() throws Throwable {
        Node node;
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            node = master.createNode();
            tx.success();
        }
        HighlyAvailableGraphDatabase readOnlySlave = cluster.getMemberByServerId(new InstanceId(2));
        try (Transaction tx = readOnlySlave.beginTx();){
            Node slaveNode = readOnlySlave.getNodeById(node.getId());
            slaveNode.setProperty("foo", (Object)"bar");
            tx.success();
        }
        catch (TransactionFailureException ex) {
            Assert.assertThat((Object)ex.getCause(), (Matcher)CoreMatchers.instanceOf(ReadOnlyDbException.class));
        }
    }

    @Test
    public void givenClusterWithReadOnlySlaveWhenAddNewLabelOnSlaveThenThrowException() throws Throwable {
        Node node;
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            node = master.createNode();
            tx.success();
        }
        HighlyAvailableGraphDatabase readOnlySlave = cluster.getMemberByServerId(new InstanceId(2));
        try (Transaction tx = readOnlySlave.beginTx();){
            Node slaveNode = readOnlySlave.getNodeById(node.getId());
            slaveNode.addLabel(DynamicLabel.label((String)"FOO"));
            tx.success();
        }
        catch (TransactionFailureException ex) {
            Assert.assertThat((Object)ex.getCause(), (Matcher)CoreMatchers.instanceOf(ReadOnlyDbException.class));
        }
    }

    @Test
    public void givenClusterWithReadOnlySlaveWhenAddNewRelTypeOnSlaveThenThrowException() throws Throwable {
        Node node2;
        Node node;
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            node = master.createNode();
            node2 = master.createNode();
            tx.success();
        }
        HighlyAvailableGraphDatabase readOnlySlave = cluster.getMemberByServerId(new InstanceId(2));
        try (Transaction tx = readOnlySlave.beginTx();){
            Node slaveNode = readOnlySlave.getNodeById(node.getId());
            Node slaveNode2 = readOnlySlave.getNodeById(node2.getId());
            slaveNode.createRelationshipTo(slaveNode2, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        catch (TransactionFailureException ex) {
            Assert.assertThat((Object)ex.getCause(), (Matcher)CoreMatchers.instanceOf(ReadOnlyDbException.class));
        }
    }
}

