/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.BackupEmbeddedIT;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.function.IntFunction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.SuppressOutput;
import org.neo4j.test.ha.ClusterRule;

public class BackupHaIT {
    @ClassRule
    public static ClusterRule clusterRule = new ClusterRule(BackupHaIT.class).withSharedSetting((Setting<?>)OnlineBackupSettings.online_backup_enabled, "true").withInstanceSetting((Setting<?>)OnlineBackupSettings.online_backup_server, new IntFunction<String>(){

        public String apply(int serverId) {
            return ":" + (4444 + serverId);
        }
    });
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private static File backupPath;

    @BeforeClass
    public static void setup() throws Exception {
        backupPath = clusterRule.cleanDirectory("backup-db");
        BackupEmbeddedIT.createSomeData((GraphDatabaseService)clusterRule.startCluster().getMaster());
    }

    @Test
    public void makeSureBackupCanBePerformedFromWronglyNamedCluster() throws Throwable {
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments("localhost:4445", backupPath.getPath(), "non.existent")));
    }

    @Test
    public void makeSureBackupCanBePerformed() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        DbRepresentation beforeChange = DbRepresentation.of((GraphDatabaseService)cluster.getMaster());
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments("localhost:4445", backupPath.getPath(), null)));
        DbRepresentation afterChange = BackupEmbeddedIT.createSomeData((GraphDatabaseService)cluster.getMaster());
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        DbRepresentation backupRepresentation = DbRepresentation.of((File)backupPath);
        Assert.assertEquals((Object)beforeChange, (Object)backupRepresentation);
        Assert.assertNotEquals((Object)backupRepresentation, (Object)afterChange);
    }

    @Test
    public void makeSureBackupCanBePerformedFromAnyInstance() throws Throwable {
        Integer[] backupPorts;
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        for (Integer port : backupPorts = new Integer[]{4445, 4446, 4447}) {
            DbRepresentation beforeChange = DbRepresentation.of((GraphDatabaseService)cluster.getMaster());
            Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments("localhost:" + port, backupPath.getPath(), null)));
            DbRepresentation afterChange = BackupEmbeddedIT.createSomeData((GraphDatabaseService)cluster.getMaster());
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            DbRepresentation backupRepresentation = DbRepresentation.of((File)backupPath);
            Assert.assertEquals((Object)beforeChange, (Object)backupRepresentation);
            Assert.assertNotEquals((Object)backupRepresentation, (Object)afterChange);
        }
    }

    private String[] backupArguments(String from, String to, String clusterName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-from");
        args.add(from);
        args.add("-to");
        args.add(to);
        if (clusterName != null) {
            args.add("-cluster");
            args.add(clusterName);
        }
        return args.toArray(new String[args.size()]);
    }
}

