/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.upgrade;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.Server;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.DefaultUnpackerDependencies;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.MasterClient214;
import org.neo4j.kernel.ha.com.master.ConversationManager;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.com.master.MasterImplTest;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.impl.api.BatchingTransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.CommandStream;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.FakeCommitment;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.CleanupRule;

public class MasterClientTest {
    private static final String MASTER_SERVER_HOST = "localhost";
    private static final int MASTER_SERVER_PORT = 9191;
    private static final int CHUNK_SIZE = 1024;
    private static final int TIMEOUT = 2000;
    private static final int TX_LOG_COUNT = 10;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public final CleanupRule cleanupRule = new CleanupRule();
    private final Monitors monitors = new Monitors();

    @Test(expected=MismatchingStoreIdException.class)
    public void newClientsShouldNotIgnoreStoreIdDifferences() throws Throwable {
        MasterImpl.SPI masterImplSPI = MasterImplTest.mockedSpi(new StoreId(1L, 2L, 3L, 4L));
        Mockito.when((Object)masterImplSPI.getTransactionChecksum(Matchers.anyLong())).thenReturn((Object)5L);
        this.cleanupRule.add((Object)this.newMasterServer(masterImplSPI));
        StoreId storeId = new StoreId(5L, 6L, 7L, 8L);
        MasterClient214 masterClient214 = (MasterClient214)this.cleanupRule.add((Object)this.newMasterClient214(storeId));
        masterClient214.handshake(1L, storeId);
    }

    @Test
    public void clientShouldReadAndApplyTransactionLogsOnNewLockSessionRequest() throws Throwable {
        MasterImpl master = (MasterImpl)Mockito.spy((Object)MasterClientTest.newMasterImpl(MasterClientTest.mockMasterImplSpiWith(StoreId.DEFAULT)));
        ((MasterImpl)Mockito.doReturn(MasterClientTest.voidResponseWithTransactionLogs()).when((Object)master)).newLockSession((RequestContext)Matchers.any(RequestContext.class));
        this.cleanupRule.add((Object)this.newMasterServer(master));
        final TransactionIdStore txIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        TransactionAppender txAppender = (TransactionAppender)Mockito.mock(TransactionAppender.class);
        Mockito.when((Object)txAppender.append((TransactionRepresentation)Matchers.any(TransactionRepresentation.class), Matchers.anyLong())).thenAnswer((Answer)new Answer<Commitment>(){

            public Commitment answer(InvocationOnMock invocation) throws Throwable {
                return new FakeCommitment(((Long)invocation.getArguments()[1]).longValue(), txIdStore);
            }
        });
        final BatchingTransactionRepresentationStoreApplier txApplier = (BatchingTransactionRepresentationStoreApplier)Mockito.mock(BatchingTransactionRepresentationStoreApplier.class);
        final IndexUpdatesValidator indexUpdatesValidator = (IndexUpdatesValidator)Mockito.mock(IndexUpdatesValidator.class);
        Mockito.when((Object)indexUpdatesValidator.validate((TransactionRepresentation)Matchers.any(TransactionRepresentation.class))).thenReturn((Object)ValidatedIndexUpdates.NONE);
        Dependencies deps = new Dependencies();
        KernelHealth health = (KernelHealth)Mockito.mock(KernelHealth.class);
        Mockito.when((Object)health.isHealthy()).thenReturn((Object)true);
        deps.satisfyDependencies(new Object[]{Mockito.mock(LogicalTransactionStore.class), Mockito.mock(LogFile.class), Mockito.mock(LogRotation.class), health, txAppender, txApplier, txIdStore, indexUpdatesValidator, NullLogService.getInstance()});
        DefaultUnpackerDependencies dependencies = new DefaultUnpackerDependencies((DependencyResolver)deps){

            public BatchingTransactionRepresentationStoreApplier transactionRepresentationStoreApplier() {
                return txApplier;
            }

            public IndexUpdatesValidator indexUpdatesValidator() {
                return indexUpdatesValidator;
            }
        };
        ResponseUnpacker unpacker = (ResponseUnpacker)MasterClientTest.initAndStart(new TransactionCommittingResponseUnpacker((TransactionCommittingResponseUnpacker.Dependencies)dependencies, 100));
        MasterClient masterClient = (MasterClient)this.cleanupRule.add((Object)this.newMasterClient214(StoreId.DEFAULT, unpacker));
        masterClient.newLockSession(new RequestContext(1L, 2, 3, 4L, 5L));
        ((TransactionAppender)Mockito.verify((Object)txAppender, (VerificationMode)Mockito.times((int)10))).append((TransactionRepresentation)Matchers.any(TransactionRepresentation.class), Matchers.anyLong());
        ((BatchingTransactionRepresentationStoreApplier)Mockito.verify((Object)txApplier, (VerificationMode)Mockito.times((int)10))).apply((CommandStream)Matchers.any(TransactionRepresentation.class), (ValidatedIndexUpdates)Matchers.any(ValidatedIndexUpdates.class), (LockGroup)Matchers.any(LockGroup.class), Matchers.anyLong(), (TransactionApplicationMode)Matchers.any(TransactionApplicationMode.class));
        ((TransactionIdStore)Mockito.verify((Object)txIdStore, (VerificationMode)Mockito.times((int)10))).transactionClosed(Matchers.anyLong(), Matchers.anyLong(), Matchers.anyLong());
    }

    private static MasterImpl.SPI mockMasterImplSpiWith(StoreId storeId) {
        return (MasterImpl.SPI)Mockito.when((Object)((MasterImpl.SPI)Mockito.mock(MasterImpl.SPI.class)).storeId()).thenReturn((Object)storeId).getMock();
    }

    private MasterServer newMasterServer(MasterImpl.SPI masterImplSPI) throws Throwable {
        MasterImpl masterImpl = new MasterImpl(masterImplSPI, (ConversationManager)Mockito.mock(ConversationManager.class), (MasterImpl.Monitor)Mockito.mock(MasterImpl.Monitor.class), MasterClientTest.masterConfig());
        return this.newMasterServer(masterImpl);
    }

    private static MasterImpl newMasterImpl(MasterImpl.SPI masterImplSPI) {
        return new MasterImpl(masterImplSPI, (ConversationManager)Mockito.mock(ConversationManager.class), (MasterImpl.Monitor)Mockito.mock(MasterImpl.Monitor.class), MasterClientTest.masterConfig());
    }

    private MasterServer newMasterServer(MasterImpl masterImpl) throws Throwable {
        return MasterClientTest.initAndStart(new MasterServer((Master)masterImpl, (LogProvider)NullLogProvider.getInstance(), MasterClientTest.masterServerConfiguration(), (TxChecksumVerifier)Mockito.mock(TxChecksumVerifier.class), (ByteCounterMonitor)this.monitors.newMonitor(ByteCounterMonitor.class, MasterClient.class, new String[0]), (RequestMonitor)this.monitors.newMonitor(RequestMonitor.class, MasterClient.class, new String[0]), (ConversationManager)Mockito.mock(ConversationManager.class)));
    }

    private MasterClient214 newMasterClient214(StoreId storeId) throws Throwable {
        return MasterClientTest.initAndStart(new MasterClient214(MASTER_SERVER_HOST, 9191, (LogProvider)NullLogProvider.getInstance(), storeId, 2000L, 2000L, 1, 1024, ResponseUnpacker.NO_OP_RESPONSE_UNPACKER, (ByteCounterMonitor)this.monitors.newMonitor(ByteCounterMonitor.class, MasterClient214.class, new String[0]), (RequestMonitor)this.monitors.newMonitor(RequestMonitor.class, MasterClient214.class, new String[0])));
    }

    private MasterClient214 newMasterClient214(StoreId storeId, ResponseUnpacker responseUnpacker) throws Throwable {
        return MasterClientTest.initAndStart(new MasterClient214(MASTER_SERVER_HOST, 9191, (LogProvider)NullLogProvider.getInstance(), storeId, 2000L, 2000L, 1, 1024, responseUnpacker, (ByteCounterMonitor)this.monitors.newMonitor(ByteCounterMonitor.class, MasterClient214.class, new String[0]), (RequestMonitor)this.monitors.newMonitor(RequestMonitor.class, MasterClient214.class, new String[0])));
    }

    private static Response<Void> voidResponseWithTransactionLogs() {
        return new TransactionStreamResponse(null, StoreId.DEFAULT, new TransactionStream(){

            public void accept(Visitor<CommittedTransactionRepresentation, IOException> visitor) throws IOException {
                for (int i = 1; i <= 10; ++i) {
                    visitor.visit((Object)MasterClientTest.committedTransactionRepresentation(i));
                }
            }
        }, ResourceReleaser.NO_OP);
    }

    private static CommittedTransactionRepresentation committedTransactionRepresentation(int id) {
        return new CommittedTransactionRepresentation(new LogEntryStart(id, id, (long)id, (long)(id - 1), new byte[0], LogPosition.UNSPECIFIED), (TransactionRepresentation)new PhysicalTransactionRepresentation(Arrays.asList(MasterClientTest.nodeCommand())), (LogEntryCommit)new OnePhaseCommit((long)id, (long)id));
    }

    private static Command nodeCommand() {
        int nodeId = new Random().nextInt();
        NodeRecord before = new NodeRecord((long)nodeId, false, -1L, -1L, false);
        NodeRecord after = new NodeRecord((long)nodeId, false, -1L, -1L, true);
        return new Command.NodeCommand().init(before, after);
    }

    private static <T extends Lifecycle> T initAndStart(T element) throws Throwable {
        element.init();
        element.start();
        return element;
    }

    private static Config masterConfig() {
        return new Config(MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "1"}));
    }

    private static Server.Configuration masterServerConfiguration() {
        return new Server.Configuration(){

            public long getOldChannelThreshold() {
                return -1L;
            }

            public int getMaxConcurrentTransactions() {
                return 1;
            }

            public int getChunkSize() {
                return 1024;
            }

            public HostnamePort getServerAddress() {
                return new HostnamePort(MasterClientTest.MASTER_SERVER_HOST, 9191);
            }
        };
    }
}

