/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.function.Suppliers;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.SlaveLockManager;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.community.CommunityLockManger;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.logging.Log;

public class SlaveLockManagerTest {
    @Test
    public void shutsDownLocalLocks() throws Throwable {
        Locks localLocks = (Locks)Mockito.mock(Locks.class);
        SlaveLockManager slaveLockManager = SlaveLockManagerTest.newSlaveLockManager(localLocks);
        slaveLockManager.close();
        ((Locks)Mockito.verify((Object)localLocks)).close();
    }

    @Test
    public void doesNotCreateClientsAfterShutdown() throws Throwable {
        SlaveLockManager slaveLockManager = SlaveLockManagerTest.newSlaveLockManager((Locks)new CommunityLockManger());
        Assert.assertNotNull((Object)slaveLockManager.newClient());
        slaveLockManager.close();
        try {
            slaveLockManager.newClient();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    private static SlaveLockManager newSlaveLockManager(Locks localLocks) {
        RequestContextFactory requestContextFactory = new RequestContextFactory(1, Suppliers.singleton((Object)Mockito.mock(TransactionIdStore.class)));
        AvailabilityGuard availabilityGuard = new AvailabilityGuard(Clock.SYSTEM_CLOCK, (Log)Mockito.mock(Log.class));
        return new SlaveLockManager(localLocks, requestContextFactory, (Master)Mockito.mock(Master.class), availabilityGuard);
    }
}

