/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.index;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.ha.BeginTx;
import org.neo4j.ha.FinishTx;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.ha.ClusterRule;

public class IndexOperationsIT {
    @ClassRule
    public static ClusterRule clusterRule = new ClusterRule(IndexOperationsIT.class);
    protected ClusterManager.ManagedCluster cluster;

    @Before
    public void setup() throws Exception {
        this.cluster = clusterRule.startCluster();
    }

    @Test
    public void index_modifications_are_propagated() throws Exception {
        String key = "name";
        String value = "Mattias";
        HighlyAvailableGraphDatabase author = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        long node = this.createNode(author, key, value, true);
        for (HighlyAvailableGraphDatabase db : this.cluster.getAllMembers()) {
            ((UpdatePuller)db.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
            this.assertNodeAndIndexingExists(db, node, key, value);
        }
    }

    @Test
    public void index_objects_can_be_reused_after_role_switch() throws Throwable {
        Throwable throwable;
        Transaction transaction;
        HighlyAvailableGraphDatabase db;
        String key = "key";
        String value = "value";
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        long nodeId = this.createNode(master, key, value, true);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HashMap<HighlyAvailableGraphDatabase, IndexManager> indexManagers = new HashMap<HighlyAvailableGraphDatabase, IndexManager>();
        HashMap<HighlyAvailableGraphDatabase, Index> indexes = new HashMap<HighlyAvailableGraphDatabase, Index>();
        for (HighlyAvailableGraphDatabase db2 : this.cluster.getAllMembers()) {
            Transaction transaction2 = db2.beginTx();
            Throwable throwable2 = null;
            try {
                indexManagers.put(db2, db2.index());
                indexes.put(db2, db2.index().forNodes(key));
                transaction2.success();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (transaction2 == null) continue;
                if (throwable2 != null) {
                    try {
                        transaction2.close();
                    }
                    catch (Throwable throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    continue;
                }
                transaction2.close();
            }
        }
        ClusterManager.RepairKit repair = this.cluster.shutdown(master);
        indexManagers.remove(master);
        indexes.remove(master);
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[]{master}));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable((int)1));
        for (Map.Entry entry : indexManagers.entrySet()) {
            db = (HighlyAvailableGraphDatabase)entry.getKey();
            transaction = db.beginTx();
            throwable = null;
            try {
                IndexManager indexManager = (IndexManager)entry.getValue();
                Assert.assertTrue((boolean)indexManager.existsForNodes(key));
                Assert.assertEquals((long)nodeId, (long)((Node)indexManager.forNodes(key).get(key, (Object)value).getSingle()).getId());
            }
            catch (Throwable indexManager) {
                throwable = indexManager;
                throw indexManager;
            }
            finally {
                if (transaction == null) continue;
                if (throwable != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable indexManager) {
                        throwable.addSuppressed(indexManager);
                    }
                    continue;
                }
                transaction.close();
            }
        }
        for (Map.Entry entry : indexes.entrySet()) {
            db = (HighlyAvailableGraphDatabase)entry.getKey();
            transaction = db.beginTx();
            throwable = null;
            try {
                Index index = (Index)entry.getValue();
                Assert.assertEquals((long)nodeId, (long)((Node)index.get(key, (Object)value).getSingle()).getId());
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (transaction == null) continue;
                if (throwable != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                transaction.close();
            }
        }
        repair.repair();
    }

    @Test
    public void put_if_absent_works_across_instances() throws Exception {
        String key = "key2";
        String value = "value2";
        HighlyAvailableGraphDatabase db1 = this.cluster.getMaster();
        HighlyAvailableGraphDatabase db2 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        long node = this.createNode(db1, key, value, false);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        OtherThreadExecutor w1 = new OtherThreadExecutor("w1", (Object)db1);
        OtherThreadExecutor w2 = new OtherThreadExecutor("w2", (Object)db2);
        Transaction tx1 = (Transaction)w1.execute((OtherThreadExecutor.WorkerCommand)new BeginTx());
        Transaction tx2 = (Transaction)w2.execute((OtherThreadExecutor.WorkerCommand)new BeginTx());
        Assert.assertNull((Object)w2.execute((OtherThreadExecutor.WorkerCommand)new PutIfAbsent(node, key, value)));
        Future w1Future = w1.executeDontWait((OtherThreadExecutor.WorkerCommand)new PutIfAbsent(node, key, value));
        w1.waitUntilWaiting();
        w2.execute((OtherThreadExecutor.WorkerCommand)new FinishTx(tx2, true));
        tx2.success();
        tx2.close();
        Assert.assertNotNull(w1Future.get());
        w1.execute((OtherThreadExecutor.WorkerCommand)new FinishTx(tx1, true));
        this.assertNodeAndIndexingExists(db1, node, key, value);
        this.assertNodeAndIndexingExists(db2, node, key, value);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertNodeAndIndexingExists(this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{db1, db2}), node, key, value);
        w2.close();
        w1.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long createNode(HighlyAvailableGraphDatabase author, String key, Object value, boolean index) {
        try (Transaction tx = author.beginTx();){
            Node node = author.createNode();
            node.setProperty(key, value);
            if (index) {
                author.index().forNodes(key).add((PropertyContainer)node, key, value);
            }
            tx.success();
            long l = node.getId();
            return l;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    private void assertNodeAndIndexingExists(HighlyAvailableGraphDatabase db, long nodeId, String key, Object value) {
        try (Transaction transaction = db.beginTx();){
            Node node = db.getNodeById(nodeId);
            Assert.assertEquals((Object)value, (Object)node.getProperty(key));
            Assert.assertTrue((boolean)db.index().existsForNodes(key));
            Assert.assertEquals((Object)node, (Object)db.index().forNodes(key).get(key, value).getSingle());
        }
    }

    private static class PutIfAbsent
    implements OtherThreadExecutor.WorkerCommand<HighlyAvailableGraphDatabase, Node> {
        private final long node;
        private final String key;
        private final String value;

        public PutIfAbsent(long node, String key, String value) {
            this.node = node;
            this.key = key;
            this.value = value;
        }

        public Node doWork(HighlyAvailableGraphDatabase state) {
            return (Node)state.index().forNodes(this.key).putIfAbsent((PropertyContainer)state.getNodeById(this.node), this.key, (Object)this.value);
        }
    }
}

