/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.function.IntFunction;
import org.neo4j.function.Predicate;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.TargetDirectory;

public class ClusterRule
extends ExternalResource
implements ClusterManager.ClusterBuilder<ClusterRule> {
    private ClusterManager.Builder clusterManagerBuilder;
    private ClusterManager clusterManager;
    private File storeDirectory;
    private List<Predicate<ClusterManager.ManagedCluster>> availabilityChecks = Arrays.asList(ClusterManager.allSeesAllAsAvailable());
    private final TargetDirectory.TestDirectory testDirectory;
    private ClusterManager.ManagedCluster cluster;

    public ClusterRule(Class<?> testClass) {
        this.testDirectory = TargetDirectory.testDirForTest(testClass);
        this.clusterManagerBuilder = new ClusterManager.Builder().withSharedSetting(GraphDatabaseSettings.store_internal_log_level, "DEBUG").withSharedSetting(ClusterSettings.default_timeout, "1s").withSharedSetting(HaSettings.tx_push_factor, "0").withSharedSetting(GraphDatabaseSettings.pagecache_memory, "8m");
    }

    public ClusterRule withRootDirectory(File root) {
        throw new UnsupportedOperationException();
    }

    public ClusterRule withSeedDir(File seedDir) {
        this.clusterManagerBuilder = this.clusterManagerBuilder.withSeedDir(seedDir);
        return this;
    }

    public ClusterRule withStoreDirInitializer(ClusterManager.StoreDirInitializer initializer) {
        this.clusterManagerBuilder = this.clusterManagerBuilder.withStoreDirInitializer(initializer);
        return this;
    }

    public ClusterRule withDbFactory(HighlyAvailableGraphDatabaseFactory dbFactory) {
        this.clusterManagerBuilder = this.clusterManagerBuilder.withDbFactory(dbFactory);
        return this;
    }

    public ClusterRule withProvider(ClusterManager.Provider provider) {
        this.clusterManagerBuilder = this.clusterManagerBuilder.withProvider(provider);
        return this;
    }

    public ClusterRule withInstanceConfig(Map<String, IntFunction<String>> commonConfig) {
        this.clusterManagerBuilder = this.clusterManagerBuilder.withInstanceConfig(commonConfig);
        return this;
    }

    public ClusterRule withInstanceSetting(Setting<?> setting, IntFunction<String> valueFunction) {
        this.clusterManagerBuilder = this.clusterManagerBuilder.withInstanceSetting(setting, valueFunction);
        return this;
    }

    public ClusterRule withSharedConfig(Map<String, String> commonConfig) {
        this.clusterManagerBuilder = this.clusterManagerBuilder.withSharedConfig(commonConfig);
        return this;
    }

    public ClusterRule withSharedSetting(Setting<?> setting, String value) {
        this.clusterManagerBuilder = this.clusterManagerBuilder.withSharedSetting(setting, value);
        return this;
    }

    @SafeVarargs
    public final ClusterRule availabilityChecks(Predicate<ClusterManager.ManagedCluster> ... checks) {
        this.availabilityChecks = Arrays.asList(checks);
        return this;
    }

    public ClusterManager.ManagedCluster startCluster() throws Exception {
        if (this.cluster != null) {
            return this.cluster;
        }
        this.clusterManager = this.clusterManagerBuilder.withRootDirectory(this.storeDirectory).build();
        try {
            this.clusterManager.start();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        for (Predicate<ClusterManager.ManagedCluster> availabilityCheck : this.availabilityChecks) {
            cluster.await(availabilityCheck);
        }
        this.cluster = cluster;
        return this.cluster;
    }

    public Statement apply(final Statement base, final Description description) {
        Statement testMethod = new Statement(){

            public void evaluate() throws Throwable {
                String name = description.getMethodName() != null ? description.getMethodName() : description.getClassName();
                ClusterRule.this.storeDirectory = ClusterRule.this.testDirectory.directory(name);
                base.evaluate();
            }
        };
        Statement testMethodWithBeforeAndAfter = super.apply(testMethod, description);
        return this.testDirectory.apply(testMethodWithBeforeAndAfter, description);
    }

    protected void after() {
        try {
            if (this.clusterManager != null) {
                this.clusterManager.shutdown();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public File directory(String name) {
        return this.testDirectory.directory(name);
    }

    public File cleanDirectory(String name) throws IOException {
        return this.testDirectory.cleanDirectory(name);
    }

    public static IntFunction<String> constant(String value) {
        return ClusterManager.constant((String)value);
    }

    public static IntFunction<String> intBase(final int oneBasedServerId) {
        return new IntFunction<String>(){

            public String apply(int serverId) {
                return String.valueOf(oneBasedServerId + serverId);
            }
        };
    }

    public static IntFunction<String> stringWithIntBase(final String prefix, final int oneBasedServerId) {
        return new IntFunction<String>(){

            public String apply(int serverId) {
                return prefix + (oneBasedServerId + serverId);
            }
        };
    }
}

