/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Settings;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.EnterpriseConfigurationMigrator;

@Description(value="High Availability configuration settings")
public class HaSettings {
    @Migrator
    public static final ConfigurationMigrator migrator = new EnterpriseConfigurationMigrator();
    @Description(value="How long a slave will wait for response from master before giving up.")
    public static final Setting<Long> read_timeout = Settings.setting((String)"ha.read_timeout", (Function)Settings.DURATION, (String)"20s");
    @Description(value="Timeout for request threads waiting for instance to become master or slave.")
    public static final Setting<Long> state_switch_timeout = Settings.setting((String)"ha.state_switch_timeout", (Function)Settings.DURATION, (String)"120s");
    @Description(value="Timeout for waiting for internal conditions during state switch, like for transactions to complete, before switching to master or slave.")
    public static final Setting<Long> internal_state_switch_timeout = Settings.setting((String)"ha.internal_state_switch_timeout", (Function)Settings.DURATION, (String)"10s");
    @Description(value="Timeout for taking remote (write) locks on slaves. Defaults to ha.read_timeout.")
    public static final Setting<Long> lock_read_timeout = Settings.setting((String)"ha.lock_read_timeout", (Function)Settings.DURATION, read_timeout);
    @Description(value="Maximum number of connections a slave can have to the master.")
    public static final Setting<Integer> max_concurrent_channels_per_slave = Settings.setting((String)"ha.max_concurrent_channels_per_slave", (Function)Settings.INTEGER, (String)"20", (Function2[])new Function2[]{Settings.min((Comparable)Integer.valueOf(1))});
    @Description(value="Hostname and port to bind the HA server.")
    public static final Setting<HostnamePort> ha_server = Settings.setting((String)"ha.server", (Function)Settings.HOSTNAME_PORT, (String)"0.0.0.0:6001-6011");
    @Description(value="Whether this instance should only participate as slave in cluster. If set to `true`, it will never be elected as master.")
    public static final Setting<Boolean> slave_only = Settings.setting((String)"ha.slave_only", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Policy for how to handle branched data.")
    public static final Setting<BranchedDataPolicy> branched_data_policy = Settings.setting((String)"ha.branched_data_policy", (Function)Settings.options(BranchedDataPolicy.class), (String)"keep_all");
    @Description(value="Require authorization for access to the HA status endpoints.")
    public static final Setting<Boolean> ha_status_auth_enabled = Settings.setting((String)"dbms.security.ha_status_auth_enabled", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Max size of the data chunks that flows between master and slaves in HA. Bigger size may increase throughput, but may also be more sensitive to variations in bandwidth, whereas lower size increases tolerance for bandwidth variations.")
    public static final Setting<Long> com_chunk_size = Settings.setting((String)"ha.com_chunk_size", (Function)Settings.BYTES, (String)"2M", (Function2[])new Function2[]{Settings.min((Comparable)Long.valueOf(1024L))});
    @Description(value="Interval of pulling updates from master.")
    public static final Setting<Long> pull_interval = Settings.setting((String)"ha.pull_interval", (Function)Settings.DURATION, (String)"0s");
    @Description(value="The amount of slaves the master will ask to replicate a committed transaction. ")
    public static final Setting<Integer> tx_push_factor = Settings.setting((String)"ha.tx_push_factor", (Function)Settings.INTEGER, (String)"1", (Function2[])new Function2[]{Settings.min((Comparable)Integer.valueOf(0))});
    @Description(value="Push strategy of a transaction to a slave during commit.")
    public static final Setting<TxPushStrategy> tx_push_strategy = Settings.setting((String)"ha.tx_push_strategy", (Function)Settings.options(TxPushStrategy.class), (String)TxPushStrategy.fixed_descending.name());
    @Description(value="Size of batches of transactions applied on slaves when pulling from master")
    public static final Setting<Integer> pull_apply_batch_size = Settings.setting((String)"ha.pull_apply_batch_size", (Function)Settings.INTEGER, (String)"100");

    public static enum TxPushStrategy {
        round_robin,
        fixed,
        fixed_descending,
        fixed_ascending;

    }
}

