/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.cluster.InstanceId;
import org.neo4j.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.SlaveUpdatePuller;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullerScheduler;
import org.neo4j.kernel.ha.UpdatePullingTransactionObligationFulfiller;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class PullerFactory {
    private final RequestContextFactory requestContextFactory;
    private final Master master;
    private final LastUpdateTime lastUpdateTime;
    private final LogProvider logging;
    private final InstanceId serverId;
    private final InvalidEpochExceptionHandler invalidEpochHandler;
    private final long pullInterval;
    private final JobScheduler jobScheduler;
    private final DependencyResolver dependencyResolver;
    private final AvailabilityGuard availabilityGuard;
    private final HighAvailabilityMemberStateMachine memberStateMachine;
    private final Monitors monitors;

    public PullerFactory(RequestContextFactory requestContextFactory, Master master, LastUpdateTime lastUpdateTime, LogProvider logging, InstanceId serverId, InvalidEpochExceptionHandler invalidEpochHandler, long pullInterval, JobScheduler jobScheduler, DependencyResolver dependencyResolver, AvailabilityGuard availabilityGuard, HighAvailabilityMemberStateMachine memberStateMachine, Monitors monitors) {
        this.requestContextFactory = requestContextFactory;
        this.master = master;
        this.lastUpdateTime = lastUpdateTime;
        this.logging = logging;
        this.serverId = serverId;
        this.invalidEpochHandler = invalidEpochHandler;
        this.pullInterval = pullInterval;
        this.jobScheduler = jobScheduler;
        this.dependencyResolver = dependencyResolver;
        this.availabilityGuard = availabilityGuard;
        this.memberStateMachine = memberStateMachine;
        this.monitors = monitors;
    }

    public SlaveUpdatePuller createSlaveUpdatePuller() {
        return new SlaveUpdatePuller(this.requestContextFactory, this.master, this.lastUpdateTime, this.logging, this.serverId, this.availabilityGuard, this.invalidEpochHandler, (SlaveUpdatePuller.Monitor)this.monitors.newMonitor(SlaveUpdatePuller.Monitor.class, new String[0]));
    }

    public UpdatePullingTransactionObligationFulfiller createObligationFulfiller(UpdatePuller updatePuller) {
        return new UpdatePullingTransactionObligationFulfiller(updatePuller, this.memberStateMachine, this.serverId, (Supplier<TransactionIdStore>)this.dependencyResolver.provideDependency(TransactionIdStore.class));
    }

    public UpdatePullerScheduler createUpdatePullerScheduler(UpdatePuller updatePuller) {
        return new UpdatePullerScheduler(this.jobScheduler, this.logging, updatePuller, this.pullInterval);
    }
}

