/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.backup.OnlineBackupKernelExtension;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.Server;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.com.storecopy.TransactionObligationFulfiller;
import org.neo4j.function.Function;
import org.neo4j.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.MasterClient210;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.StoreOutOfDateException;
import org.neo4j.kernel.ha.StoreUnableToParticipateInClusterException;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullerScheduler;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.modeswitch.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveImpl;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.store.ForeignStoreException;
import org.neo4j.kernel.ha.store.UnableToCopyStoreFromOldMasterException;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.TransactionCounters;
import org.neo4j.kernel.impl.transaction.log.MissingLogDataException;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.StoreUtil;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;

public class SwitchToSlave {
    private static final Class<? extends Lifecycle>[] SERVICES_TO_RESTART_FOR_STORE_COPY = new Class[]{StoreLockerLifecycleAdapter.class, DataSourceManager.class, RequestContextFactory.class, TransactionCommittingResponseUnpacker.class, IndexConfigStore.class, OnlineBackupKernelExtension.class};
    private final File storeDir;
    private final Supplier<NeoStoreDataSource> neoDataSourceSupplier;
    private final Supplier<TransactionIdStore> transactionIdStoreSupplier;
    private final Function<Slave, SlaveServer> slaveServerFactory;
    private final UpdatePuller updatePuller;
    private final PageCache pageCache;
    private final Monitors monitors;
    private final TransactionCounters transactionCounters;
    private final Log userLog;
    private final Log msgLog;
    private final Config config;
    private final DependencyResolver resolver;
    private final HaIdGeneratorFactory idGeneratorFactory;
    private final DelegateInvocationHandler<Master> masterDelegateHandler;
    private final ClusterMemberAvailability clusterMemberAvailability;
    private final RequestContextFactory requestContextFactory;
    private final MasterClientResolver masterClientResolver;
    private final StoreCopyClient storeCopyClient;
    private final PullerFactory updatePullerFactory;
    private final Monitor monitor;

    public SwitchToSlave(File storeDir, LogService logService, FileSystemAbstraction fileSystemAbstraction, Config config, DependencyResolver resolver, HaIdGeneratorFactory idGeneratorFactory, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, RequestContextFactory requestContextFactory, PullerFactory pullerFactory, Iterable<KernelExtensionFactory<?>> kernelExtensions, MasterClientResolver masterClientResolver, Monitor monitor, StoreCopyClient.Monitor storeCopyMonitor, Supplier<NeoStoreDataSource> neoDataSourceSupplier, Supplier<TransactionIdStore> transactionIdStoreSupplier, Function<Slave, SlaveServer> slaveServerFactory, UpdatePuller updatePuller, PageCache pageCache, Monitors monitors, TransactionCounters transactionCounters) {
        this(storeDir, logService, config, resolver, idGeneratorFactory, masterDelegateHandler, clusterMemberAvailability, requestContextFactory, pullerFactory, masterClientResolver, monitor, new StoreCopyClient(storeDir, config, kernelExtensions, logService.getUserLogProvider(), fileSystemAbstraction, pageCache, storeCopyMonitor, false), neoDataSourceSupplier, transactionIdStoreSupplier, slaveServerFactory, updatePuller, pageCache, monitors, transactionCounters);
    }

    SwitchToSlave(File storeDir, LogService logService, Config config, DependencyResolver resolver, HaIdGeneratorFactory idGeneratorFactory, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, RequestContextFactory requestContextFactory, PullerFactory pullerFactory, MasterClientResolver masterClientResolver, Monitor monitor, StoreCopyClient storeCopyClient, Supplier<NeoStoreDataSource> neoDataSourceSupplier, Supplier<TransactionIdStore> transactionIdStoreSupplier, Function<Slave, SlaveServer> slaveServerFactory, UpdatePuller updatePuller, PageCache pageCache, Monitors monitors, TransactionCounters transactionCounters) {
        this.neoDataSourceSupplier = neoDataSourceSupplier;
        this.transactionIdStoreSupplier = transactionIdStoreSupplier;
        this.slaveServerFactory = slaveServerFactory;
        this.updatePuller = updatePuller;
        this.pageCache = pageCache;
        this.monitors = monitors;
        this.transactionCounters = transactionCounters;
        this.userLog = logService.getUserLog(this.getClass());
        this.storeDir = storeDir;
        this.config = config;
        this.resolver = resolver;
        this.idGeneratorFactory = idGeneratorFactory;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.requestContextFactory = requestContextFactory;
        this.msgLog = logService.getInternalLog(this.getClass());
        this.masterDelegateHandler = masterDelegateHandler;
        this.updatePullerFactory = pullerFactory;
        this.monitor = monitor;
        this.masterClientResolver = masterClientResolver;
        this.storeCopyClient = storeCopyClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI switchToSlave(LifeSupport haCommunicationLife, URI me, URI masterUri, CancellationRequest cancellationRequest) throws Throwable {
        URI slaveUri;
        boolean success = false;
        this.monitor.switchToSlaveStarted();
        long deadline = Clock.SYSTEM_CLOCK.currentTimeMillis() + (Long)this.config.get(HaSettings.internal_state_switch_timeout);
        while (this.transactionCounters.getNumberOfActiveTransactions() > 0L && Clock.SYSTEM_CLOCK.currentTimeMillis() < deadline) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
        try {
            InstanceId myId = (InstanceId)this.config.get(ClusterSettings.server_id);
            this.userLog.info("ServerId %s, moving to slave for master %s", new Object[]{myId, masterUri});
            assert (masterUri != null);
            this.idGeneratorFactory.switchToSlave();
            this.copyStoreFromMasterIfNeeded(masterUri, cancellationRequest);
            if (cancellationRequest.cancellationRequested()) {
                this.msgLog.info("Switch to slave cancelled during store copy if no local store is present.");
                URI uRI = null;
                return uRI;
            }
            NeoStoreDataSource neoDataSource = (NeoStoreDataSource)this.neoDataSourceSupplier.get();
            neoDataSource.afterModeSwitch();
            StoreId myStoreId = neoDataSource.getStoreId();
            boolean consistencyChecksExecutedSuccessfully = this.executeConsistencyChecks((TransactionIdStore)this.transactionIdStoreSupplier.get(), masterUri, myStoreId, cancellationRequest);
            if (!consistencyChecksExecutedSuccessfully) {
                this.msgLog.info("Switch to slave cancelled due to consistency check failure.");
                URI uRI = null;
                return uRI;
            }
            if (cancellationRequest.cancellationRequested()) {
                this.msgLog.info("Switch to slave cancelled after consistency checks.");
                URI uRI = null;
                return uRI;
            }
            slaveUri = this.startHaCommunication(haCommunicationLife, neoDataSource, me, masterUri, myStoreId, cancellationRequest);
            if (slaveUri == null) {
                this.msgLog.info("Switch to slave unable to connect.");
                URI uRI = null;
                return uRI;
            }
            success = true;
            this.userLog.info("ServerId %s, successfully moved to slave for master %s", new Object[]{myId, masterUri});
        }
        finally {
            this.monitor.switchToSlaveCompleted(success);
        }
        return slaveUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStoreFromMasterIfNeeded(URI masterUri, CancellationRequest cancellationRequest) throws Throwable {
        if (!NeoStores.isStorePresent((PageCache)this.pageCache, (File)this.storeDir)) {
            boolean success = false;
            this.monitor.storeCopyStarted();
            LifeSupport copyLife = new LifeSupport();
            try {
                boolean masterIsOld;
                MasterClient masterClient = this.newMasterClient(masterUri, null, copyLife);
                copyLife.start();
                boolean bl = masterIsOld = MasterClient.CURRENT.compareTo(masterClient.getProtocolVersion()) > 0;
                if (masterIsOld) {
                    throw new UnableToCopyStoreFromOldMasterException(MasterClient.CURRENT.getApplicationProtocol(), masterClient.getProtocolVersion().getApplicationProtocol());
                }
                this.copyStoreFromMaster(masterClient, cancellationRequest);
                success = true;
            }
            finally {
                this.monitor.storeCopyCompleted(success);
                copyLife.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeConsistencyChecks(TransactionIdStore txIdStore, URI masterUri, StoreId storeId, CancellationRequest cancellationRequest) throws Throwable {
        LifeSupport consistencyCheckLife = new LifeSupport();
        try {
            MasterClient masterClient = this.newMasterClient(masterUri, storeId, consistencyCheckLife);
            consistencyCheckLife.start();
            if (cancellationRequest.cancellationRequested()) {
                boolean bl = false;
                return bl;
            }
            this.checkDataConsistency(masterClient, txIdStore, storeId, masterUri);
        }
        finally {
            consistencyCheckLife.shutdown();
        }
        return true;
    }

    void checkDataConsistency(MasterClient masterClient, TransactionIdStore txIdStore, StoreId storeId, URI masterUri) throws Throwable {
        try {
            this.userLog.info("Checking store consistency with master");
            this.checkMyStoreIdAndMastersStoreId(storeId, masterUri);
            this.checkDataConsistencyWithMaster(masterUri, masterClient, storeId, txIdStore);
            this.userLog.info("Store is consistent");
        }
        catch (StoreUnableToParticipateInClusterException upe) {
            this.userLog.info("The store is inconsistent. Will treat it as branched and fetch a new one from the master");
            this.msgLog.warn("Current store is unable to participate in the cluster; fetching new store from master", (Throwable)upe);
            try {
                this.stopServicesAndHandleBranchedStore((BranchedDataPolicy)((Object)this.config.get(HaSettings.branched_data_policy)));
            }
            catch (IOException e) {
                this.msgLog.warn("Failed while trying to handle branched data", (Throwable)e);
            }
            throw upe;
        }
        catch (MismatchingStoreIdException e) {
            this.userLog.info("The store does not represent the same database as master. Will remove and fetch a new one from master");
            if (txIdStore.getLastCommittedTransactionId() == 1L) {
                this.msgLog.warn("Found and deleting empty store with mismatching store id", (Throwable)e);
                this.stopServicesAndHandleBranchedStore(BranchedDataPolicy.keep_none);
                throw e;
            }
            this.msgLog.error("Store cannot participate in cluster due to mismatching store IDs", (Throwable)e);
            throw new ForeignStoreException(e.getExpected(), e.getEncountered());
        }
    }

    private void checkMyStoreIdAndMastersStoreId(StoreId myStoreId, URI masterUri) {
        ClusterMembers clusterMembers = (ClusterMembers)this.resolver.resolveDependency(ClusterMembers.class);
        InstanceId serverId = HighAvailabilityModeSwitcher.getServerId(masterUri);
        Iterable<ClusterMember> members = clusterMembers.getMembers();
        ClusterMember master = (ClusterMember)Iterables.first((Iterable)Iterables.filter(ClusterMembers.hasInstanceId(serverId), members));
        if (master == null) {
            throw new IllegalStateException("Cannot find the master among " + members + " with master serverId=" + serverId + " and uri=" + masterUri);
        }
        StoreId masterStoreId = master.getStoreId();
        if (!myStoreId.equals((Object)masterStoreId)) {
            throw new MismatchingStoreIdException(myStoreId, master.getStoreId());
        }
        if (!myStoreId.equalsByUpgradeId(master.getStoreId())) {
            throw new BranchedDataException("My store with " + myStoreId + " was updated independently from " + "master's store " + masterStoreId);
        }
    }

    private URI startHaCommunication(LifeSupport haCommunicationLife, NeoStoreDataSource neoDataSource, URI me, URI masterUri, StoreId storeId, CancellationRequest cancellationRequest) throws IllegalArgumentException, InterruptedException {
        MasterClient master = this.newMasterClient(masterUri, neoDataSource.getStoreId(), haCommunicationLife);
        TransactionObligationFulfiller obligationFulfiller = (TransactionObligationFulfiller)this.resolver.resolveDependency(TransactionObligationFulfiller.class);
        UpdatePullerScheduler updatePullerScheduler = this.updatePullerFactory.createUpdatePullerScheduler(this.updatePuller);
        SlaveImpl slaveImpl = new SlaveImpl(obligationFulfiller);
        SlaveServer server = (SlaveServer)((Object)this.slaveServerFactory.apply((Object)slaveImpl));
        if (cancellationRequest.cancellationRequested()) {
            this.msgLog.info("Switch to slave cancelled, unable to start HA-communication");
            return null;
        }
        this.masterDelegateHandler.setDelegate(master);
        haCommunicationLife.add((Lifecycle)updatePullerScheduler);
        haCommunicationLife.add((Lifecycle)server);
        haCommunicationLife.start();
        if (!this.catchUpWithMaster(this.updatePuller)) {
            return null;
        }
        URI slaveHaURI = this.createHaURI(me, server);
        this.clusterMemberAvailability.memberIsAvailable("slave", slaveHaURI, storeId);
        return slaveHaURI;
    }

    private boolean catchUpWithMaster(UpdatePuller updatePuller) throws IllegalArgumentException, InterruptedException {
        this.monitor.catchupStarted();
        RequestContext catchUpRequestContext = this.requestContextFactory.newRequestContext();
        this.userLog.info("Catching up with master. I'm at %s", new Object[]{catchUpRequestContext});
        if (!updatePuller.tryPullUpdates()) {
            return false;
        }
        this.userLog.info("Now caught up with master");
        this.monitor.catchupCompleted();
        return true;
    }

    private URI createHaURI(URI me, Server<?, ?> server) {
        String hostString = ServerUtil.getHostString((InetSocketAddress)server.getSocketAddress());
        int port = server.getSocketAddress().getPort();
        InstanceId serverId = (InstanceId)this.config.get(ClusterSettings.server_id);
        String host = hostString.contains("0.0.0.0") ? me.getHost() : hostString;
        return URI.create("ha://" + host + ":" + port + "?serverId=" + serverId);
    }

    private void copyStoreFromMaster(final MasterClient masterClient, CancellationRequest cancellationRequest) throws Throwable {
        try {
            this.userLog.info("Copying store from master");
            this.storeCopyClient.copyStore(new StoreCopyClient.StoreCopyRequester(){

                public Response<?> copyStore(StoreWriter writer) {
                    return masterClient.copyStore(new RequestContext(0L, ((InstanceId)SwitchToSlave.this.config.get(ClusterSettings.server_id)).toIntegerIndex(), 0, 1L, 0L), writer);
                }

                public void done() {
                }
            }, cancellationRequest);
            this.startServicesAgain();
            this.userLog.info("Finished copying store from master");
        }
        catch (Throwable t) {
            this.cleanStoreDir();
            throw t;
        }
    }

    void cleanStoreDir() throws IOException {
        StoreUtil.cleanStoreDir((File)this.storeDir);
    }

    private MasterClient newMasterClient(URI masterUri, StoreId storeId, LifeSupport life) {
        MasterClient masterClient = this.masterClientResolver.instantiate(masterUri.getHost(), masterUri.getPort(), this.monitors, storeId, life);
        if (masterClient.getProtocolVersion().compareTo(MasterClient210.PROTOCOL_VERSION) < 0) {
            this.idGeneratorFactory.enableCompatibilityMode();
        }
        return masterClient;
    }

    private void startServicesAgain() throws Throwable {
        this.msgLog.debug("Starting services again");
        for (Class<? extends Lifecycle> serviceClass : SERVICES_TO_RESTART_FOR_STORE_COPY) {
            ((Lifecycle)this.resolver.resolveDependency(serviceClass)).start();
        }
    }

    void stopServicesAndHandleBranchedStore(BranchedDataPolicy branchPolicy) throws Throwable {
        this.msgLog.debug("Stopping services to handle branched store");
        for (int i = SERVICES_TO_RESTART_FOR_STORE_COPY.length - 1; i >= 0; --i) {
            Class<? extends Lifecycle> serviceClass = SERVICES_TO_RESTART_FOR_STORE_COPY[i];
            ((Lifecycle)this.resolver.resolveDependency(serviceClass)).stop();
        }
        branchPolicy.handle(this.storeDir);
    }

    private void checkDataConsistencyWithMaster(URI availableMasterId, Master master, StoreId storeId, TransactionIdStore transactionIdStore) {
        HandshakeResult handshake;
        TransactionId myLastCommittedTxData = transactionIdStore.getLastCommittedTransaction();
        long myLastCommittedTx = myLastCommittedTxData.transactionId();
        try (Response<HandshakeResult> response = master.handshake(myLastCommittedTx, storeId);){
            handshake = (HandshakeResult)response.response();
            this.requestContextFactory.setEpoch(handshake.epoch());
        }
        catch (BranchedDataException e) {
            throw new BranchedDataException("The database stored on this machine has diverged from that of the master. This will be automatically resolved.", e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MissingLogDataException) {
                throw new StoreOutOfDateException("The master is missing the log required to complete the consistency check", e.getCause());
            }
            throw e;
        }
        long myChecksum = myLastCommittedTxData.checksum();
        if (myChecksum != handshake.txChecksum()) {
            String msg = "The cluster contains two logically different versions of the database.. This will be automatically resolved. Details: I (server_id:" + this.config.get(ClusterSettings.server_id) + ") think checksum for txId (" + myLastCommittedTx + ") is " + myChecksum + ", but master (server_id:" + HighAvailabilityModeSwitcher.getServerId(availableMasterId) + ") says that it's " + handshake.txChecksum() + ", where handshake is " + handshake;
            throw new BranchedDataException(msg);
        }
        this.msgLog.info("Checksum for last committed tx ok with lastTxId=" + myLastCommittedTx + " with checksum=" + myChecksum, new Object[]{true});
    }

    public static interface Monitor {
        public void switchToSlaveStarted();

        public void switchToSlaveCompleted(boolean var1);

        public void storeCopyStarted();

        public void storeCopyCompleted(boolean var1);

        public void catchupStarted();

        public void catchupCompleted();
    }
}

