/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.factory;

import java.io.File;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.client.ClusterClientModule;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.logging.NettyLoggerFactory;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.member.paxos.MemberIsAvailable;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberAvailability;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberEvents;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcast;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.snapshot.Snapshot;
import org.neo4j.com.Server;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.DefaultUnpackerDependencies;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.function.BiFunction;
import org.neo4j.function.Factory;
import org.neo4j.function.Function;
import org.neo4j.function.Predicate;
import org.neo4j.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.BranchDetectingTxVerifier;
import org.neo4j.kernel.ha.BranchedDataMigrator;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighAvailabilityDiagnostics;
import org.neo4j.kernel.ha.HighAvailabilityLogger;
import org.neo4j.kernel.ha.HighAvailabilityMemberInfoProvider;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.TransactionChecksumLookup;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.ConversationSPI;
import org.neo4j.kernel.ha.cluster.DefaultConversationSPI;
import org.neo4j.kernel.ha.cluster.DefaultElectionCredentialsProvider;
import org.neo4j.kernel.ha.cluster.DefaultMasterImplSPI;
import org.neo4j.kernel.ha.cluster.HANewSnapshotFunction;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.SimpleHighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.HighAvailabilitySlaves;
import org.neo4j.kernel.ha.cluster.member.ObservedClusterMembers;
import org.neo4j.kernel.ha.cluster.modeswitch.CommitProcessSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.ComponentSwitcherContainer;
import org.neo4j.kernel.ha.cluster.modeswitch.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.LabelTokenCreatorSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.LockManagerSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.PropertyKeyCreatorSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.RelationshipTypeCreatorSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.UpdatePullerSwitcher;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.ConversationManager;
import org.neo4j.kernel.ha.com.master.DefaultSlaveFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlaveFactory;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.factory.HighlyAvailableCommitProcessFactory;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.management.ClusterDatabaseInfoProvider;
import org.neo4j.kernel.ha.management.HighlyAvailableKernelData;
import org.neo4j.kernel.ha.transaction.CommitPusher;
import org.neo4j.kernel.ha.transaction.OnDiskLastTxIdGetter;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.index.RemoveOrphanConstraintIndexesOnStartup;
import org.neo4j.kernel.impl.core.DelegatingLabelTokenHolder;
import org.neo4j.kernel.impl.core.DelegatingPropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.DelegatingRelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.ReadOnlyTokenCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.enterprise.EnterpriseConstraintSemantics;
import org.neo4j.kernel.impl.enterprise.EnterpriseEditionModule;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByDatabaseModeException;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public class HighlyAvailableEditionModule
extends EditionModule {
    public HighAvailabilityMemberStateMachine memberStateMachine;
    public ClusterMembers members;

    public HighlyAvailableEditionModule(final PlatformModule platformModule) {
        LifeSupport life = platformModule.life;
        life.add((Lifecycle)platformModule.dataSourceManager);
        LifeSupport paxosLife = new LifeSupport();
        LifeSupport clusteringLife = new LifeSupport();
        FileSystemAbstraction fs = platformModule.fileSystem;
        File storeDir = platformModule.storeDir;
        final Config config = platformModule.config;
        Dependencies dependencies = platformModule.dependencies;
        final LogService logging = platformModule.logging;
        final Monitors monitors = platformModule.monitors;
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new NettyLoggerFactory(logging.getInternalLogProvider()));
        life.add((Lifecycle)new BranchedDataMigrator(platformModule.storeDir));
        DelegateInvocationHandler<Master> masterDelegateInvocationHandler = new DelegateInvocationHandler<Master>(Master.class);
        Master master = (Master)Proxy.newProxyInstance(Master.class.getClassLoader(), new Class[]{Master.class}, masterDelegateInvocationHandler);
        InstanceId serverId = (InstanceId)config.get(ClusterSettings.server_id);
        RequestContextFactory requestContextFactory = (RequestContextFactory)((Object)dependencies.satisfyDependency((Object)new RequestContextFactory(serverId.toIntegerIndex(), (Supplier<TransactionIdStore>)dependencies.provideDependency(TransactionIdStore.class))));
        TransactionCommittingResponseUnpacker responseUnpacker = (TransactionCommittingResponseUnpacker)dependencies.satisfyDependency((Object)new TransactionCommittingResponseUnpacker((TransactionCommittingResponseUnpacker.Dependencies)new DefaultUnpackerDependencies((DependencyResolver)dependencies), ((Integer)config.get(HaSettings.pull_apply_batch_size)).intValue()));
        Supplier kernelProvider = dependencies.provideDependency(KernelAPI.class);
        this.transactionStartTimeout = (Long)config.get(HaSettings.state_switch_timeout);
        DelegateInvocationHandler<ClusterMemberEvents> clusterEventsDelegateInvocationHandler = new DelegateInvocationHandler<ClusterMemberEvents>(ClusterMemberEvents.class);
        DelegateInvocationHandler<HighAvailabilityMemberContext> memberContextDelegateInvocationHandler = new DelegateInvocationHandler<HighAvailabilityMemberContext>(HighAvailabilityMemberContext.class);
        DelegateInvocationHandler<ClusterMemberAvailability> clusterMemberAvailabilityDelegateInvocationHandler = new DelegateInvocationHandler<ClusterMemberAvailability>(ClusterMemberAvailability.class);
        ClusterMemberEvents clusterEvents = (ClusterMemberEvents)dependencies.satisfyDependency((Object)((ClusterMemberEvents)Proxy.newProxyInstance(ClusterMemberEvents.class.getClassLoader(), new Class[]{ClusterMemberEvents.class, Lifecycle.class}, clusterEventsDelegateInvocationHandler)));
        HighAvailabilityMemberContext memberContext = (HighAvailabilityMemberContext)Proxy.newProxyInstance(HighAvailabilityMemberContext.class.getClassLoader(), new Class[]{HighAvailabilityMemberContext.class}, memberContextDelegateInvocationHandler);
        ClusterMemberAvailability clusterMemberAvailability = (ClusterMemberAvailability)dependencies.satisfyDependency((Object)((ClusterMemberAvailability)Proxy.newProxyInstance(ClusterMemberAvailability.class.getClassLoader(), new Class[]{ClusterMemberAvailability.class}, clusterMemberAvailabilityDelegateInvocationHandler)));
        final AtomicReference<HighAvailabilityMemberStateMachine> electionProviderRef = new AtomicReference<HighAvailabilityMemberStateMachine>();
        Object electionCredentialsProvider = (Boolean)config.get(HaSettings.slave_only) != false ? new NotElectableElectionCredentialsProvider() : new DefaultElectionCredentialsProvider((InstanceId)config.get(ClusterSettings.server_id), new OnDiskLastTxIdGetter((Supplier<NeoStores>)platformModule.dependencies.provideDependency(NeoStores.class)), new HighAvailabilityMemberInfoProvider(){

            @Override
            public HighAvailabilityMemberState getHighAvailabilityMemberState() {
                return ((HighAvailabilityMemberStateMachine)electionProviderRef.get()).getCurrentState();
            }
        });
        ObjectStreamFactory objectStreamFactory = new ObjectStreamFactory();
        ClusterClientModule clusterClientModule = new ClusterClientModule(clusteringLife, dependencies, monitors, config, logging, (ElectionCredentialsProvider)electionCredentialsProvider);
        final ClusterClient clusterClient = clusterClientModule.clusterClient;
        PaxosClusterMemberEvents localClusterEvents = new PaxosClusterMemberEvents((Snapshot)clusterClient, (Cluster)clusterClient, (Heartbeat)clusterClient, (AtomicBroadcast)clusterClient, logging.getInternalLogProvider(), (Predicate)new Predicate<PaxosClusterMemberEvents.ClusterMembersSnapshot>(){

            public boolean test(PaxosClusterMemberEvents.ClusterMembersSnapshot item) {
                for (MemberIsAvailable member : item.getCurrentAvailableMembers()) {
                    if (!member.getRoleUri().getScheme().equals("ha") || !HighAvailabilityModeSwitcher.getServerId(member.getRoleUri()).equals(platformModule.config.get(ClusterSettings.server_id))) continue;
                    logging.getInternalLog(PaxosClusterMemberEvents.class).error(String.format("Instance %s has the same serverId as ours (%s) - will not join this cluster", member.getRoleUri(), ((InstanceId)config.get(ClusterSettings.server_id)).toIntegerIndex()));
                    return true;
                }
                return true;
            }
        }, (Function2)new HANewSnapshotFunction(), (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory, (NamedThreadFactory.Monitor)platformModule.monitors.newMonitor(NamedThreadFactory.Monitor.class, new String[0]));
        clusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){
            boolean hasRequestedElection = true;

            public void enteredCluster(ClusterConfiguration clusterConfiguration) {
                clusterClient.performRoleElections();
            }

            public void elected(String role, InstanceId instanceId, URI electedMember) {
                if (this.hasRequestedElection && role.equals("coordinator")) {
                    clusterClient.removeClusterListener((ClusterListener)this);
                }
            }
        });
        SimpleHighAvailabilityMemberContext localMemberContext = new SimpleHighAvailabilityMemberContext(clusterClient.getServerId(), (Boolean)config.get(HaSettings.slave_only));
        PaxosClusterMemberAvailability localClusterMemberAvailability = new PaxosClusterMemberAvailability(clusterClient.getServerId(), (BindingNotifier)clusterClient, (AtomicBroadcast)clusterClient, logging.getInternalLogProvider(), (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory);
        memberContextDelegateInvocationHandler.setDelegate(localMemberContext);
        clusterEventsDelegateInvocationHandler.setDelegate((ClusterMemberEvents)localClusterEvents);
        clusterMemberAvailabilityDelegateInvocationHandler.setDelegate((ClusterMemberAvailability)localClusterMemberAvailability);
        ObservedClusterMembers observedMembers = new ObservedClusterMembers(logging.getInternalLogProvider(), (Cluster)clusterClient, (Heartbeat)clusterClient, clusterEvents, (InstanceId)config.get(ClusterSettings.server_id));
        HighAvailabilityMemberStateMachine stateMachine = new HighAvailabilityMemberStateMachine(memberContext, platformModule.availabilityGuard, observedMembers, clusterEvents, (Election)clusterClient, logging.getInternalLogProvider());
        this.members = (ClusterMembers)dependencies.satisfyDependency((Object)new ClusterMembers(observedMembers, stateMachine));
        this.memberStateMachine = (HighAvailabilityMemberStateMachine)paxosLife.add((Lifecycle)stateMachine);
        electionProviderRef.set(this.memberStateMachine);
        HighAvailabilityLogger highAvailabilityLogger = new HighAvailabilityLogger(logging.getUserLogProvider(), (InstanceId)config.get(ClusterSettings.server_id));
        platformModule.availabilityGuard.addListener((AvailabilityGuard.AvailabilityListener)highAvailabilityLogger);
        clusterEvents.addClusterMemberListener((ClusterMemberListener)highAvailabilityLogger);
        clusterClient.addClusterListener((ClusterListener)highAvailabilityLogger);
        paxosLife.add((Lifecycle)clusterEvents);
        paxosLife.add((Lifecycle)localClusterMemberAvailability);
        this.idGeneratorFactory = (IdGeneratorFactory)dependencies.satisfyDependency((Object)this.createIdGeneratorFactory(masterDelegateInvocationHandler, logging.getInternalLogProvider(), requestContextFactory, fs));
        final AtomicReference<HighAvailabilityModeSwitcher> exceptionHandlerRef = new AtomicReference<HighAvailabilityModeSwitcher>();
        InvalidEpochExceptionHandler invalidEpochHandler = new InvalidEpochExceptionHandler(){

            @Override
            public void handle() {
                ((HighAvailabilityModeSwitcher)exceptionHandlerRef.get()).forceElections();
            }
        };
        MasterClientResolver masterClientResolver = new MasterClientResolver(logging.getInternalLogProvider(), (ResponseUnpacker)responseUnpacker, invalidEpochHandler, ((Long)config.get(HaSettings.read_timeout)).intValue(), ((Long)config.get(HaSettings.lock_read_timeout)).intValue(), (Integer)config.get(HaSettings.max_concurrent_channels_per_slave), ((Long)config.get(HaSettings.com_chunk_size)).intValue());
        LastUpdateTime lastUpdateTime = new LastUpdateTime();
        DelegateInvocationHandler<UpdatePuller> updatePullerDelegate = new DelegateInvocationHandler<UpdatePuller>(UpdatePuller.class);
        UpdatePuller updatePullerProxy = (UpdatePuller)Proxy.newProxyInstance(UpdatePuller.class.getClassLoader(), new Class[]{UpdatePuller.class}, updatePullerDelegate);
        dependencies.satisfyDependency((Object)updatePullerProxy);
        PullerFactory pullerFactory = new PullerFactory(requestContextFactory, master, lastUpdateTime, logging.getInternalLogProvider(), serverId, invalidEpochHandler, (Long)config.get(HaSettings.pull_interval), platformModule.jobScheduler, (DependencyResolver)dependencies, platformModule.availabilityGuard, this.memberStateMachine, monitors);
        dependencies.satisfyDependency((Object)paxosLife.add((Lifecycle)pullerFactory.createObligationFulfiller(updatePullerProxy)));
        Function<Slave, SlaveServer> slaveServerFactory = new Function<Slave, SlaveServer>(){

            public SlaveServer apply(Slave slave) throws RuntimeException {
                return new SlaveServer(slave, HighlyAvailableEditionModule.this.slaveServerConfig(config), logging.getInternalLogProvider(), (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, SlaveServer.class, new String[0]), (RequestMonitor)monitors.newMonitor(RequestMonitor.class, SlaveServer.class, new String[0]));
            }
        };
        SwitchToSlave switchToSlaveInstance = new SwitchToSlave(platformModule.storeDir, logging, platformModule.fileSystem, config, (DependencyResolver)dependencies, (HaIdGeneratorFactory)this.idGeneratorFactory, masterDelegateInvocationHandler, clusterMemberAvailability, requestContextFactory, pullerFactory, platformModule.kernelExtensions.listFactories(), masterClientResolver, (SwitchToSlave.Monitor)monitors.newMonitor(SwitchToSlave.Monitor.class, new String[0]), (StoreCopyClient.Monitor)monitors.newMonitor(StoreCopyClient.Monitor.class, new String[0]), (Supplier<NeoStoreDataSource>)dependencies.provideDependency(NeoStoreDataSource.class), (Supplier<TransactionIdStore>)dependencies.provideDependency(TransactionIdStore.class), slaveServerFactory, updatePullerProxy, platformModule.pageCache, monitors, platformModule.transactionMonitor);
        Factory<MasterImpl.SPI> masterSPIFactory = new Factory<MasterImpl.SPI>(){

            public MasterImpl.SPI newInstance() {
                return new DefaultMasterImplSPI((GraphDatabaseAPI)platformModule.graphDatabaseFacade, platformModule.fileSystem, platformModule.monitors, HighlyAvailableEditionModule.this.labelTokenHolder, HighlyAvailableEditionModule.this.propertyKeyTokenHolder, HighlyAvailableEditionModule.this.relationshipTypeTokenHolder, HighlyAvailableEditionModule.this.idGeneratorFactory, (TransactionCommitProcess)platformModule.dependencies.resolveDependency(TransactionCommitProcess.class), (CheckPointer)platformModule.dependencies.resolveDependency(CheckPointer.class), (TransactionIdStore)platformModule.dependencies.resolveDependency(TransactionIdStore.class), (LogicalTransactionStore)platformModule.dependencies.resolveDependency(LogicalTransactionStore.class), (NeoStoreDataSource)platformModule.dependencies.resolveDependency(NeoStoreDataSource.class));
            }
        };
        Factory<ConversationSPI> conversationSPIFactory = new Factory<ConversationSPI>(){

            public ConversationSPI newInstance() {
                return new DefaultConversationSPI(HighlyAvailableEditionModule.this.lockManager, platformModule.jobScheduler);
            }
        };
        Factory<ConversationManager> conversationManagerFactory = new Factory<ConversationManager>((Factory)conversationSPIFactory, config){
            final /* synthetic */ Factory val$conversationSPIFactory;
            final /* synthetic */ Config val$config;
            {
                this.val$conversationSPIFactory = factory;
                this.val$config = config;
            }

            public ConversationManager newInstance() {
                return new ConversationManager((ConversationSPI)this.val$conversationSPIFactory.newInstance(), this.val$config);
            }
        };
        BiFunction<ConversationManager, LifeSupport, Master> masterFactory = new BiFunction<ConversationManager, LifeSupport, Master>((Factory)masterSPIFactory, monitors, config){
            final /* synthetic */ Factory val$masterSPIFactory;
            final /* synthetic */ Monitors val$monitors;
            final /* synthetic */ Config val$config;
            {
                this.val$masterSPIFactory = factory;
                this.val$monitors = monitors;
                this.val$config = config;
            }

            public Master apply(ConversationManager conversationManager, LifeSupport life) {
                return (Master)life.add((Lifecycle)new MasterImpl((MasterImpl.SPI)this.val$masterSPIFactory.newInstance(), conversationManager, (MasterImpl.Monitor)this.val$monitors.newMonitor(MasterImpl.Monitor.class, MasterImpl.class, new String[0]), this.val$config));
            }
        };
        BiFunction<Master, ConversationManager, MasterServer> masterServerFactory = new BiFunction<Master, ConversationManager, MasterServer>(){

            public MasterServer apply(Master master, ConversationManager conversationManager) throws RuntimeException {
                TransactionChecksumLookup txChecksumLookup = new TransactionChecksumLookup((TransactionIdStore)platformModule.dependencies.resolveDependency(TransactionIdStore.class), (LogicalTransactionStore)platformModule.dependencies.resolveDependency(LogicalTransactionStore.class));
                return new MasterServer(master, logging.getInternalLogProvider(), HighlyAvailableEditionModule.this.masterServerConfig(config), new BranchDetectingTxVerifier(logging.getInternalLogProvider(), txChecksumLookup), (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, MasterServer.class, new String[0]), (RequestMonitor)monitors.newMonitor(RequestMonitor.class, MasterServer.class, new String[0]), conversationManager);
            }
        };
        SwitchToMaster switchToMasterInstance = new SwitchToMaster(logging, (HaIdGeneratorFactory)this.idGeneratorFactory, config, (Supplier<SlaveFactory>)dependencies.provideDependency(SlaveFactory.class), conversationManagerFactory, masterFactory, masterServerFactory, masterDelegateInvocationHandler, clusterMemberAvailability, (Supplier<NeoStoreDataSource>)platformModule.dependencies.provideDependency(NeoStoreDataSource.class));
        ComponentSwitcherContainer componentSwitcherContainer = new ComponentSwitcherContainer();
        Supplier storeIdSupplier = () -> ((NeoStoreDataSource)dependencies.resolveDependency(NeoStoreDataSource.class)).getStoreId();
        HighAvailabilityModeSwitcher highAvailabilityModeSwitcher = new HighAvailabilityModeSwitcher(switchToSlaveInstance, switchToMasterInstance, (Election)clusterClient, clusterMemberAvailability, clusterClient, (Supplier<StoreId>)storeIdSupplier, (InstanceId)config.get(ClusterSettings.server_id), componentSwitcherContainer, platformModule.dataSourceManager, logging);
        exceptionHandlerRef.set(highAvailabilityModeSwitcher);
        clusterClient.addBindingListener((BindingListener)highAvailabilityModeSwitcher);
        this.memberStateMachine.addHighAvailabilityMemberListener(highAvailabilityModeSwitcher);
        paxosLife.add((Lifecycle)highAvailabilityModeSwitcher);
        componentSwitcherContainer.add(new UpdatePullerSwitcher(updatePullerDelegate, pullerFactory));
        life.add((Lifecycle)requestContextFactory);
        life.add((Lifecycle)responseUnpacker);
        platformModule.diagnosticsManager.appendProvider((DiagnosticsProvider)new HighAvailabilityDiagnostics(this.memberStateMachine, clusterClient));
        this.lockManager = (Locks)dependencies.satisfyDependency((Object)this.createLockManager(componentSwitcherContainer, config, masterDelegateInvocationHandler, requestContextFactory, platformModule.availabilityGuard, logging));
        this.propertyKeyTokenHolder = (PropertyKeyTokenHolder)dependencies.satisfyDependency((Object)new DelegatingPropertyKeyTokenHolder(this.createPropertyKeyCreator(config, componentSwitcherContainer, masterDelegateInvocationHandler, requestContextFactory, (Supplier<KernelAPI>)kernelProvider)));
        this.labelTokenHolder = (LabelTokenHolder)dependencies.satisfyDependency((Object)new DelegatingLabelTokenHolder(this.createLabelIdCreator(config, componentSwitcherContainer, masterDelegateInvocationHandler, requestContextFactory, (Supplier<KernelAPI>)kernelProvider)));
        this.relationshipTypeTokenHolder = (RelationshipTypeTokenHolder)dependencies.satisfyDependency((Object)new DelegatingRelationshipTypeTokenHolder(this.createRelationshipTypeCreator(config, componentSwitcherContainer, masterDelegateInvocationHandler, requestContextFactory, (Supplier<KernelAPI>)kernelProvider)));
        dependencies.satisfyDependency((Object)this.createKernelData(config, (GraphDatabaseAPI)platformModule.graphDatabaseFacade, this.members, fs, platformModule.pageCache, storeDir, lastUpdateTime, (Supplier<NeoStores>)dependencies.provideDependency(NeoStores.class), life));
        this.commitProcessFactory = this.createCommitProcessFactory(dependencies, logging, monitors, config, paxosLife, clusterClient, this.members, platformModule.jobScheduler, master, requestContextFactory, componentSwitcherContainer);
        this.headerInformationFactory = this.createHeaderInformationFactory(memberContext);
        this.schemaWriteGuard = new SchemaWriteGuard(){

            public void assertSchemaWritesAllowed() throws InvalidTransactionTypeKernelException {
                if (!HighlyAvailableEditionModule.this.memberStateMachine.isMaster()) {
                    throw new InvalidTransactionTypeKernelException("Modifying the database schema can only be done on the master server, this server is a slave. Please issue schema modification commands directly to the master.");
                }
            }
        };
        this.upgradeConfiguration = new HAUpgradeConfiguration();
        this.constraintSemantics = new EnterpriseConstraintSemantics();
        this.registerRecovery((String)config.get(GraphDatabaseFacadeFactory.Configuration.editionName), (DependencyResolver)dependencies, logging);
        this.publishEditionInfo(config, (UsageData)dependencies.resolveDependency(UsageData.class));
        life.add((Lifecycle)clusteringLife);
        life.add((Lifecycle)paxosLife);
    }

    private void publishEditionInfo(Config config, UsageData sysInfo) {
        sysInfo.set(UsageDataKeys.edition, (Object)UsageDataKeys.Edition.enterprise);
        sysInfo.set(UsageDataKeys.operationalMode, (Object)UsageDataKeys.OperationalMode.ha);
        sysInfo.set(UsageDataKeys.serverId, (Object)((InstanceId)config.get(ClusterSettings.server_id)).toString());
    }

    protected TransactionHeaderInformationFactory createHeaderInformationFactory(final HighAvailabilityMemberContext memberContext) {
        return new TransactionHeaderInformationFactory.WithRandomBytes(){

            protected TransactionHeaderInformation createUsing(byte[] additionalHeader) {
                return new TransactionHeaderInformation(memberContext.getElectedMasterId().toIntegerIndex(), memberContext.getMyId().toIntegerIndex(), additionalHeader);
            }
        };
    }

    private CommitProcessFactory createCommitProcessFactory(Dependencies dependencies, LogService logging, Monitors monitors, Config config, LifeSupport paxosLife, ClusterClient clusterClient, ClusterMembers members, JobScheduler jobScheduler, Master master, RequestContextFactory requestContextFactory, ComponentSwitcherContainer componentSwitcherContainer) {
        DefaultSlaveFactory slaveFactory = (DefaultSlaveFactory)dependencies.satisfyDependency((Object)new DefaultSlaveFactory(logging.getInternalLogProvider(), monitors, ((Long)config.get(HaSettings.com_chunk_size)).intValue()));
        Slaves slaves = (Slaves)dependencies.satisfyDependency((Object)paxosLife.add((Lifecycle)new HighAvailabilitySlaves(members, (Cluster)clusterClient, slaveFactory)));
        TransactionPropagator transactionPropagator = new TransactionPropagator(TransactionPropagator.from(config), logging.getInternalLog(TransactionPropagator.class), slaves, new CommitPusher(jobScheduler));
        paxosLife.add((Lifecycle)transactionPropagator);
        DelegateInvocationHandler<TransactionCommitProcess> commitProcessDelegate = new DelegateInvocationHandler<TransactionCommitProcess>(TransactionCommitProcess.class);
        CommitProcessSwitcher commitProcessSwitcher = new CommitProcessSwitcher(transactionPropagator, master, commitProcessDelegate, requestContextFactory, (DependencyResolver)dependencies);
        componentSwitcherContainer.add(commitProcessSwitcher);
        return new HighlyAvailableCommitProcessFactory(commitProcessDelegate);
    }

    private IdGeneratorFactory createIdGeneratorFactory(DelegateInvocationHandler<Master> masterDelegateInvocationHandler, LogProvider logging, RequestContextFactory requestContextFactory, FileSystemAbstraction fs) {
        this.idGeneratorFactory = new HaIdGeneratorFactory(masterDelegateInvocationHandler, logging, requestContextFactory, fs);
        ((HaIdGeneratorFactory)this.idGeneratorFactory).switchToMaster();
        return this.idGeneratorFactory;
    }

    private Locks createLockManager(ComponentSwitcherContainer componentSwitcherContainer, Config config, DelegateInvocationHandler<Master> masterDelegateInvocationHandler, RequestContextFactory requestContextFactory, AvailabilityGuard availabilityGuard, LogService logging) {
        DelegateInvocationHandler<Locks> lockManagerDelegate = new DelegateInvocationHandler<Locks>(Locks.class);
        Locks lockManager = (Locks)Proxy.newProxyInstance(Locks.class.getClassLoader(), new Class[]{Locks.class}, lockManagerDelegate);
        Factory locksFactory = () -> CommunityEditionModule.createLockManager((Config)config, (LogService)logging);
        LockManagerSwitcher lockManagerModeSwitcher = new LockManagerSwitcher(lockManagerDelegate, masterDelegateInvocationHandler, requestContextFactory, availabilityGuard, (Factory<Locks>)locksFactory);
        componentSwitcherContainer.add(lockManagerModeSwitcher);
        return lockManager;
    }

    private TokenCreator createRelationshipTypeCreator(Config config, ComponentSwitcherContainer componentSwitcherContainer, DelegateInvocationHandler<Master> masterInvocationHandler, RequestContextFactory requestContextFactory, Supplier<KernelAPI> kernelProvider) {
        if (((Boolean)config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        DelegateInvocationHandler<TokenCreator> relationshipTypeCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator relationshipTypeCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, relationshipTypeCreatorDelegate);
        RelationshipTypeCreatorSwitcher typeCreatorModeSwitcher = new RelationshipTypeCreatorSwitcher(relationshipTypeCreatorDelegate, masterInvocationHandler, requestContextFactory, kernelProvider, this.idGeneratorFactory);
        componentSwitcherContainer.add(typeCreatorModeSwitcher);
        return relationshipTypeCreator;
    }

    private TokenCreator createPropertyKeyCreator(Config config, ComponentSwitcherContainer componentSwitcherContainer, DelegateInvocationHandler<Master> masterDelegateInvocationHandler, RequestContextFactory requestContextFactory, Supplier<KernelAPI> kernelProvider) {
        if (((Boolean)config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        DelegateInvocationHandler<TokenCreator> propertyKeyCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator propertyTokenCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, propertyKeyCreatorDelegate);
        PropertyKeyCreatorSwitcher propertyKeyCreatorModeSwitcher = new PropertyKeyCreatorSwitcher(propertyKeyCreatorDelegate, masterDelegateInvocationHandler, requestContextFactory, kernelProvider, this.idGeneratorFactory);
        componentSwitcherContainer.add(propertyKeyCreatorModeSwitcher);
        return propertyTokenCreator;
    }

    private TokenCreator createLabelIdCreator(Config config, ComponentSwitcherContainer componentSwitcherContainer, DelegateInvocationHandler<Master> masterDelegateInvocationHandler, RequestContextFactory requestContextFactory, Supplier<KernelAPI> kernelProvider) {
        if (((Boolean)config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        DelegateInvocationHandler<TokenCreator> labelIdCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator labelIdCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, labelIdCreatorDelegate);
        LabelTokenCreatorSwitcher modeSwitcher = new LabelTokenCreatorSwitcher(labelIdCreatorDelegate, masterDelegateInvocationHandler, requestContextFactory, kernelProvider, this.idGeneratorFactory);
        componentSwitcherContainer.add(modeSwitcher);
        return labelIdCreator;
    }

    private KernelData createKernelData(Config config, GraphDatabaseAPI graphDb, ClusterMembers members, FileSystemAbstraction fs, PageCache pageCache, File storeDir, LastUpdateTime lastUpdateTime, Supplier<NeoStores> neoStoreSupplier, LifeSupport life) {
        OnDiskLastTxIdGetter txIdGetter = new OnDiskLastTxIdGetter(neoStoreSupplier);
        ClusterDatabaseInfoProvider databaseInfo = new ClusterDatabaseInfoProvider(members, txIdGetter, lastUpdateTime);
        return (KernelData)life.add((Lifecycle)new HighlyAvailableKernelData(graphDb, members, databaseInfo, fs, pageCache, storeDir, config));
    }

    protected void registerRecovery(final String editionName, final DependencyResolver dependencyResolver, final LogService logging) {
        this.memberStateMachine.addHighAvailabilityMemberListener(new HighAvailabilityMemberListener(){

            @Override
            public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
            }

            @Override
            public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.TO_MASTER) && event.getNewState().equals((Object)HighAvailabilityMemberState.MASTER)) {
                    this.doAfterRecoveryAndStartup(true);
                }
            }

            @Override
            public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.TO_SLAVE) && event.getNewState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.doAfterRecoveryAndStartup(false);
                }
            }

            @Override
            public void instanceStops(HighAvailabilityMemberChangeEvent event) {
            }

            private void doAfterRecoveryAndStartup(boolean isMaster) {
                try {
                    HighlyAvailableEditionModule.this.doAfterRecoveryAndStartup(editionName, dependencyResolver, isMaster);
                }
                catch (Throwable throwable) {
                    Log messagesLog = logging.getInternalLog(EnterpriseEditionModule.class);
                    messagesLog.error("Post recovery error", throwable);
                    try {
                        HighlyAvailableEditionModule.this.memberStateMachine.stop();
                    }
                    catch (Throwable throwable1) {
                        messagesLog.warn("Could not stop", throwable1);
                    }
                    try {
                        HighlyAvailableEditionModule.this.memberStateMachine.start();
                    }
                    catch (Throwable throwable1) {
                        messagesLog.warn("Could not start", throwable1);
                    }
                }
            }
        });
    }

    protected void doAfterRecoveryAndStartup(String editionName, DependencyResolver resolver, boolean isMaster) {
        super.doAfterRecoveryAndStartup(editionName, resolver);
        if (isMaster) {
            new RemoveOrphanConstraintIndexesOnStartup((KernelAPI)resolver.resolveDependency(KernelAPI.class), ((LogService)resolver.resolveDependency(LogService.class)).getInternalLogProvider()).perform();
        }
    }

    private Server.Configuration masterServerConfig(final Config config) {
        return new Server.Configuration(){

            public long getOldChannelThreshold() {
                return (Long)config.get(HaSettings.lock_read_timeout);
            }

            public int getMaxConcurrentTransactions() {
                return (Integer)config.get(HaSettings.max_concurrent_channels_per_slave);
            }

            public int getChunkSize() {
                return ((Long)config.get(HaSettings.com_chunk_size)).intValue();
            }

            public HostnamePort getServerAddress() {
                return (HostnamePort)config.get(HaSettings.ha_server);
            }
        };
    }

    private Server.Configuration slaveServerConfig(final Config config) {
        return new Server.Configuration(){

            public long getOldChannelThreshold() {
                return (Long)config.get(HaSettings.lock_read_timeout);
            }

            public int getMaxConcurrentTransactions() {
                return (Integer)config.get(HaSettings.max_concurrent_channels_per_slave);
            }

            public int getChunkSize() {
                return ((Long)config.get(HaSettings.com_chunk_size)).intValue();
            }

            public HostnamePort getServerAddress() {
                return (HostnamePort)config.get(HaSettings.ha_server);
            }
        };
    }

    private static final class HAUpgradeConfiguration
    implements UpgradeConfiguration {
        private HAUpgradeConfiguration() {
        }

        public void checkConfigurationAllowsAutomaticUpgrade() {
            throw new UpgradeNotAllowedByDatabaseModeException();
        }
    }
}

