/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.id;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.impl.store.id.IdRange;

public class IdRangeIterator {
    static IdRangeIterator EMPTY_ID_RANGE_ITERATOR = new IdRangeIterator(new IdRange(PrimitiveLongCollections.EMPTY_LONG_ARRAY, 0L, 0)){

        @Override
        long next() {
            return -1L;
        }
    };
    public static final long VALUE_REPRESENTING_NULL = -1L;
    private int position = 0;
    private final long[] defrag;
    private final long start;
    private final int length;

    public IdRangeIterator(IdRange idRange) {
        this.defrag = idRange.getDefragIds();
        this.start = idRange.getRangeStart();
        this.length = idRange.getRangeLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long next() {
        try {
            if (this.position < this.defrag.length) {
                long l = this.defrag[this.position];
                return l;
            }
            int offset = this.position - this.defrag.length;
            long l = offset < this.length ? this.start + (long)offset : -1L;
            return l;
        }
        finally {
            ++this.position;
        }
    }

    public String toString() {
        return "IdRangeIterator[start:" + this.start + ", length:" + this.length + ", position:" + this.position + ", defrag:" + Arrays.toString(this.defrag) + "]";
    }
}

