/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class ForeignStoreIdIT {
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    private GraphDatabaseService firstInstance;
    private GraphDatabaseService foreignInstance;

    @Test
    public void emptyForeignDbShouldJoinAfterHavingItsEmptyDbDeleted() throws Exception {
        this.firstInstance = new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.testDirectory.directory("1").getAbsolutePath()).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5001").setConfig(HaSettings.ha_server, "127.0.0.1:6031").setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").newGraphDatabase();
        String foreignDbStoreDir = this.createAnotherStore(this.testDirectory.directory("2"), 0);
        this.foreignInstance = new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(foreignDbStoreDir).setConfig(ClusterSettings.server_id, "2").setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5002").setConfig(HaSettings.ha_server, "127.0.0.1:6032").newGraphDatabase();
        long foreignNode = this.createNode(this.foreignInstance, "foreigner");
        Assert.assertEquals((long)foreignNode, (long)this.findNode(this.firstInstance, "foreigner"));
    }

    @Test
    public void nonEmptyForeignDbShouldNotBeAbleToJoin() throws Exception {
        this.firstInstance = new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.testDirectory.directory("1").getAbsolutePath()).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5001").setConfig(HaSettings.ha_server, "127.0.0.1:6041").newGraphDatabase();
        this.createNodes(this.firstInstance, 3, "first");
        String foreignDbStoreDir = this.createAnotherStore(this.testDirectory.directory("2"), 1);
        this.foreignInstance = new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(foreignDbStoreDir).setConfig(ClusterSettings.server_id, "2").setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5002").setConfig(HaSettings.ha_server, "127.0.0.1:6042").setConfig(HaSettings.state_switch_timeout, "5s").newGraphDatabase();
        try {
            this.createNode(this.foreignInstance, "foreigner");
            Assert.fail((String)"Shouldn't be able to create a node, since it shouldn't have joined");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @After
    public void after() throws Exception {
        if (this.foreignInstance != null) {
            this.foreignInstance.shutdown();
        }
        if (this.firstInstance != null) {
            this.firstInstance.shutdown();
        }
    }

    private long findNode(GraphDatabaseService db, String name) {
        try (Transaction transaction = db.beginTx();){
            for (Node node : db.getAllNodes()) {
                if (!name.equals(node.getProperty("name", null))) continue;
                long l = node.getId();
                return l;
            }
            Assert.fail((String)("Didn't find node '" + name + "' in " + db));
            long l = -1L;
            return l;
        }
    }

    private String createAnotherStore(File directory, int transactions) {
        String storeDir = directory.getAbsolutePath();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        this.createNodes(db, transactions, "node");
        db.shutdown();
        return storeDir;
    }

    private void createNodes(GraphDatabaseService db, int transactions, String prefix) {
        for (int i = 0; i < transactions; ++i) {
            this.createNode(db, prefix + i);
        }
    }

    private long createNode(GraphDatabaseService db, String name) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty("name", (Object)name);
            tx.success();
            long l = node.getId();
            return l;
        }
    }
}

