/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.SlaveUpdatePuller;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class UpdatePullerSwitchIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass());
    private ClusterManager.ManagedCluster managedCluster;

    @Before
    public void setup() throws Exception {
        this.managedCluster = this.clusterRule.withProvider(ClusterManager.clusterOfSize((int)2)).withSharedSetting((Setting<?>)HaSettings.tx_push_factor, "0").withSharedSetting((Setting<?>)HaSettings.pull_interval, "100s").startCluster();
    }

    @Test
    public void updatePullerSwitchOnNodeModeSwitch() throws Throwable {
        String masterLabel = "masterLabel";
        this.createLabeledNodeOnMaster(masterLabel);
        this.pullUpdatesOnSlave();
        this.checkLabeledNodeExistanceOnSlave(masterLabel);
        this.verifyUpdatePullerThreads();
        ClusterManager.RepairKit initialMasterRepairKit = this.managedCluster.shutdown(this.managedCluster.getMaster());
        this.managedCluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
        String pretenderMasterLabel = "pretenderMasterLabel";
        this.createLabeledNodeOnMaster(pretenderMasterLabel);
        initialMasterRepairKit.repair();
        this.managedCluster.await(ClusterManager.masterSeesSlavesAsAvailable((int)1));
        this.pullUpdatesOnSlave();
        this.checkLabeledNodeExistanceOnSlave(pretenderMasterLabel);
        this.verifyUpdatePullerThreads();
        ClusterManager.RepairKit justiceRepairKit = this.managedCluster.shutdown(this.managedCluster.getMaster());
        this.managedCluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
        String justicePrevailedLabel = "justice prevailed";
        this.createLabeledNodeOnMaster(justicePrevailedLabel);
        justiceRepairKit.repair();
        this.managedCluster.await(ClusterManager.masterSeesSlavesAsAvailable((int)1));
        this.pullUpdatesOnSlave();
        this.checkLabeledNodeExistanceOnSlave(justicePrevailedLabel);
        this.verifyUpdatePullerThreads();
    }

    private void verifyUpdatePullerThreads() {
        InstanceId masterId = (InstanceId)this.managedCluster.getMaster().platformModule.config.get(ClusterSettings.server_id);
        InstanceId slaveId = (InstanceId)this.managedCluster.getAnySlave((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]).platformModule.config.get(ClusterSettings.server_id);
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        Set<Thread> threads = allStackTraces.keySet();
        Assert.assertFalse((String)"Master should not have any puller threads", (boolean)this.findThreadWithPrefix(threads, SlaveUpdatePuller.UPDATE_PULLER_THREAD_PREFIX + masterId));
        Assert.assertTrue((String)"Slave should have active puller thread", (boolean)this.findThreadWithPrefix(threads, SlaveUpdatePuller.UPDATE_PULLER_THREAD_PREFIX + slaveId));
    }

    private boolean findThreadWithPrefix(Set<Thread> threads, String prefix) {
        for (Thread thread : threads) {
            if (!thread.getName().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private void pullUpdatesOnSlave() throws InterruptedException {
        UpdatePuller updatePuller = (UpdatePuller)this.managedCluster.getAnySlave(new HighlyAvailableGraphDatabase[0]).getDependencyResolver().resolveDependency(UpdatePuller.class);
        Assert.assertTrue((String)"We should always have some updates to pull", (boolean)updatePuller.tryPullUpdates());
    }

    private void checkLabeledNodeExistanceOnSlave(String label) {
        HighlyAvailableGraphDatabase slave = this.managedCluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction transaction = slave.beginTx();){
            this.checkNodeWithLabelExists(slave, label);
        }
    }

    private void createLabeledNodeOnMaster(String label) {
        HighlyAvailableGraphDatabase master = this.managedCluster.getMaster();
        try (Transaction transaction = master.beginTx();){
            Node masterNode = master.createNode();
            masterNode.addLabel(Label.label((String)label));
            transaction.success();
        }
    }

    private void checkNodeWithLabelExists(HighlyAvailableGraphDatabase database, String label) {
        ResourceIterator slaveNodes = database.findNodes(Label.label((String)label));
        Assert.assertEquals((long)1L, (long)Iterables.toList((Iterator)slaveNodes).size());
    }
}

