/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.TransactionTemplate;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class BiggerThanLogTxIT {
    private static final String ROTATION_THRESHOLD = "1M";
    @ClassRule
    public static ClusterRule clusterRule = new ClusterRule(BiggerThanLogTxIT.class).withSharedSetting((Setting<?>)GraphDatabaseSettings.logical_log_rotation_threshold, "1M");
    protected ClusterManager.ManagedCluster cluster;
    protected TransactionTemplate template = new TransactionTemplate().retries(10).backoff(3L, TimeUnit.SECONDS);

    @Before
    public void setup() throws Exception {
        this.cluster = clusterRule.startCluster();
    }

    @Test
    public void shouldHandleSlaveCommittingLargeTx() throws Exception {
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        int initialNodeCount = this.nodeCount((GraphDatabaseService)slave);
        this.cluster.info("Before commit large");
        int nodeCount = this.commitLargeTx((GraphDatabaseService)slave);
        this.cluster.info("Before sync");
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.cluster.info("After sync");
        this.assertAllMembersHasNodeCount(initialNodeCount + nodeCount);
        this.cluster.info("Before commit small");
        this.commitSmallTx((GraphDatabaseService)this.cluster.getMaster());
        this.cluster.info("Before sync small");
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.cluster.info("After sync small");
        this.assertAllMembersHasNodeCount(initialNodeCount + nodeCount + 1);
    }

    @Test
    public void shouldHandleMasterCommittingLargeTx() throws Exception {
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        int initialNodeCount = this.nodeCount((GraphDatabaseService)slave);
        int nodeCount = this.commitLargeTx((GraphDatabaseService)this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertAllMembersHasNodeCount(initialNodeCount + nodeCount);
        this.commitSmallTx((GraphDatabaseService)this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertAllMembersHasNodeCount(initialNodeCount + nodeCount + 1);
    }

    private void commitSmallTx(GraphDatabaseService db) {
        try (Transaction transaction = db.beginTx();){
            db.createNode();
            transaction.success();
        }
    }

    private int nodeCount(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            int count = IteratorUtil.count((Iterable)db.getAllNodes());
            tx.success();
            int n = count;
            return n;
        }
    }

    private void assertAllMembersHasNodeCount(int expectedNodeCount) {
        for (GraphDatabaseService db : this.cluster.getAllMembers()) {
            if (expectedNodeCount != this.nodeCount(db)) {
                for (int i = 0; i < 100; ++i) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    int count = this.nodeCount(db);
                    if (expectedNodeCount == count) break;
                    try {
                        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            Assert.assertEquals((long)expectedNodeCount, (long)this.nodeCount(db));
        }
    }

    private int commitLargeTx(GraphDatabaseService db) {
        return (Integer)this.template.with(db).execute(transaction -> {
            long rotationThreshold = Config.parseLongWithUnit((String)ROTATION_THRESHOLD);
            int nodeCount = 100;
            byte[] arrayProperty = new byte[(int)(rotationThreshold / (long)nodeCount)];
            for (int i = 0; i < nodeCount; ++i) {
                Node node = db.createNode();
                node.setProperty("name", (Object)("big" + i));
                node.setProperty("data", (Object)arrayProperty);
            }
            return nodeCount;
        });
    }
}

