/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.client.ClusterClientModule;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.RepeatRule;
import org.neo4j.test.SuppressOutput;
import org.neo4j.test.ha.ClusterRule;

public class ClusterTopologyChangesIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass());
    @Rule
    public final CleanupRule cleanup = new CleanupRule();
    @Rule
    public final RepeatRule repeat = new RepeatRule();
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private ClusterManager.ManagedCluster cluster;

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.withSharedSetting((Setting<?>)HaSettings.read_timeout, "1s").withSharedSetting((Setting<?>)HaSettings.state_switch_timeout, "2s").withSharedSetting((Setting<?>)HaSettings.com_chunk_size, "1024").startCluster();
    }

    @Test
    public void masterRejoinsAfterFailureAndReelection() throws Throwable {
        HighlyAvailableGraphDatabase initialMaster = this.cluster.getMaster();
        this.cluster.info("Fail master");
        ClusterManager.RepairKit kit = this.cluster.fail(initialMaster);
        this.cluster.info("Wait for 2 to become master and 3 slave");
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[]{initialMaster}));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable((int)1));
        this.cluster.info("Repair 1");
        kit.repair();
        this.cluster.info("Wait for cluster recovery");
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        Assert.assertEquals((long)3L, (long)this.cluster.size());
    }

    @Test
    @Ignore
    public void slaveShouldServeTxsAfterMasterLostQuorumWentToPendingAndThenQuorumWasRestored() throws Throwable {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        final HighlyAvailableGraphDatabase slave1 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        final HighlyAvailableGraphDatabase slave2 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{slave1});
        final CountDownLatch slave1Left = new CountDownLatch(1);
        final CountDownLatch slave2Left = new CountDownLatch(1);
        ClusterTopologyChangesIT.clusterClientOf(master).addHeartbeatListener((HeartbeatListener)new HeartbeatListener.Adapter(){

            public void failed(InstanceId server) {
                if (ClusterTopologyChangesIT.instanceIdOf(slave1).equals((Object)server)) {
                    slave1Left.countDown();
                } else if (ClusterTopologyChangesIT.instanceIdOf(slave2).equals((Object)server)) {
                    slave2Left.countDown();
                }
            }
        });
        ClusterManager.RepairKit slave1RepairKit = this.cluster.fail(slave1);
        Assert.assertTrue((boolean)slave1Left.await(60L, TimeUnit.SECONDS));
        ClusterManager.RepairKit slave2RepairKit = this.cluster.fail(slave2);
        Assert.assertTrue((boolean)slave2Left.await(60L, TimeUnit.SECONDS));
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]).negate());
        Assert.assertEquals((Object)HighAvailabilityMemberState.PENDING, (Object)master.getInstanceState());
        slave1RepairKit.repair();
        slave2RepairKit.repair();
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable((int)2));
        HighlyAvailableGraphDatabase newMaster = this.cluster.getMaster();
        final HighlyAvailableGraphDatabase newSlave1 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        final HighlyAvailableGraphDatabase newSlave2 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{newSlave1});
        final CountDownLatch slave1Unavailable = new CountDownLatch(1);
        final CountDownLatch slave2Unavailable = new CountDownLatch(1);
        ClusterMemberEvents clusterEvents = (ClusterMemberEvents)newMaster.getDependencyResolver().resolveDependency(ClusterMemberEvents.class);
        clusterEvents.addClusterMemberListener((ClusterMemberListener)new ClusterMemberListener.Adapter(){

            public void memberIsUnavailable(String role, InstanceId unavailableId) {
                if (ClusterTopologyChangesIT.instanceIdOf(newSlave1).equals((Object)unavailableId)) {
                    slave1Unavailable.countDown();
                } else if (ClusterTopologyChangesIT.instanceIdOf(newSlave2).equals((Object)unavailableId)) {
                    slave2Unavailable.countDown();
                }
            }
        });
        ClusterTopologyChangesIT.attemptTransactions(newSlave1, newSlave2);
        Assert.assertTrue((boolean)slave1Unavailable.await(60L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)slave2Unavailable.await(60L, TimeUnit.SECONDS));
        this.cluster.info("Waiting for cluster to stabilize");
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        this.cluster.info("Assert ok");
        Assert.assertNotNull((Object)ClusterTopologyChangesIT.createNodeOn(newMaster));
        Assert.assertNotNull((Object)ClusterTopologyChangesIT.createNodeOn(newSlave1));
        Assert.assertNotNull((Object)ClusterTopologyChangesIT.createNodeOn(newSlave2));
    }

    @Test
    public void failedInstanceShouldReceiveCorrectCoordinatorIdUponRejoiningCluster() throws Throwable {
        HighlyAvailableGraphDatabase initialMaster = this.cluster.getMaster();
        this.cluster.shutdown(initialMaster);
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[]{initialMaster}));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable((int)1));
        ClusterTopologyChangesIT.createNodeOn(this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        LifeSupport life = new LifeSupport();
        ClusterClientModule clusterClient = this.newClusterClient(life, new InstanceId(1));
        this.cleanup.add((Object)life);
        final AtomicReference coordinatorIdWhenReJoined = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        clusterClient.clusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){

            public void enteredCluster(ClusterConfiguration clusterConfiguration) {
                coordinatorIdWhenReJoined.set(clusterConfiguration.getElected("coordinator"));
                latch.countDown();
            }
        });
        life.start();
        Assert.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
        Assert.assertEquals((Object)new InstanceId(2), coordinatorIdWhenReJoined.get());
    }

    private static ClusterClient clusterClientOf(HighlyAvailableGraphDatabase db) {
        return (ClusterClient)db.getDependencyResolver().resolveDependency(ClusterClient.class);
    }

    private static InstanceId instanceIdOf(HighlyAvailableGraphDatabase db) {
        return ClusterTopologyChangesIT.clusterClientOf(db).getServerId();
    }

    private static Node createNodeOn(HighlyAvailableGraphDatabase db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty("key", (Object)String.valueOf(System.currentTimeMillis()));
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private ClusterClientModule newClusterClient(LifeSupport life, InstanceId id) {
        Map configMap = MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), this.cluster.getInitialHostsConfigString(), ClusterSettings.server_id.name(), String.valueOf(id.toIntegerIndex()), ClusterSettings.cluster_server.name(), "0.0.0.0:8888"});
        Config config = new Config(configMap, new Class[]{GraphDatabaseFacadeFactory.Configuration.class, GraphDatabaseSettings.class});
        FormattedLogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)System.out);
        SimpleLogService logService = new SimpleLogService((LogProvider)logProvider, (LogProvider)logProvider);
        return new ClusterClientModule(life, new Dependencies(), new Monitors(), config, (LogService)logService, (ElectionCredentialsProvider)new NotElectableElectionCredentialsProvider());
    }

    private static void attemptTransactions(HighlyAvailableGraphDatabase ... dbs) {
        for (HighlyAvailableGraphDatabase db : dbs) {
            try {
                ClusterTopologyChangesIT.createNodeOn(db);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

